package io.shiftleft.codepropertygraph.generated.nodes

import overflowdb._
import scala.jdk.CollectionConverters._

object PropertyErrorRegister {
  private var errorMap = Set[(Class[_], String)]()
  private val logger   = org.slf4j.LoggerFactory.getLogger(getClass)

  def logPropertyErrorIfFirst(clazz: Class[_], propertyName: String): Unit = {
    if (!errorMap.contains((clazz, propertyName))) {
      logger.warn("Property " + propertyName + " is deprecated for " + clazz.getName + ".")
      errorMap += ((clazz, propertyName))
    }
  }
}

object Misc {
  val reChars                           = "[](){}*+&|?.,\\$"
  def isRegex(pattern: String): Boolean = pattern.exists(reChars.contains(_))
}

/** Abstract supertype for overflowdb.Node and NewNode */
trait AbstractNode extends overflowdb.NodeOrDetachedNode {
  def label: String
}

/* A node that is stored inside an Graph (rather than e.g. DiffGraph) */
trait StoredNode extends Node with AbstractNode with Product {
  /* underlying Node in the graph.
   * since this is a StoredNode, this is always set */
  def underlying: Node = this

  /** labels of product elements, used e.g. for pretty-printing */
  def productElementLabel(n: Int): String

  /* all properties plus label and id */
  def toMap: Map[String, Any] = {
    val map = propertiesMap()
    map.put("_label", label)
    map.put("_id", id: java.lang.Long)
    map.asScala.toMap
  }

  /*Sets fields from newNode*/
  def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = ???

  def _aliasOfIn: java.util.Iterator[StoredNode]        = { java.util.Collections.emptyIterator() }
  def _argumentIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _astIn: java.util.Iterator[StoredNode]            = { java.util.Collections.emptyIterator() }
  def _bindsIn: java.util.Iterator[StoredNode]          = { java.util.Collections.emptyIterator() }
  def _bindsToIn: java.util.Iterator[StoredNode]        = { java.util.Collections.emptyIterator() }
  def _callIn: java.util.Iterator[StoredNode]           = { java.util.Collections.emptyIterator() }
  def _captureIn: java.util.Iterator[StoredNode]        = { java.util.Collections.emptyIterator() }
  def _capturedByIn: java.util.Iterator[StoredNode]     = { java.util.Collections.emptyIterator() }
  def _cdgIn: java.util.Iterator[StoredNode]            = { java.util.Collections.emptyIterator() }
  def _cfgIn: java.util.Iterator[StoredNode]            = { java.util.Collections.emptyIterator() }
  def _conditionIn: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _containsIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _dominateIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _evalTypeIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _inheritsFromIn: java.util.Iterator[StoredNode]   = { java.util.Collections.emptyIterator() }
  def _parameterLinkIn: java.util.Iterator[StoredNode]  = { java.util.Collections.emptyIterator() }
  def _pointsToIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _postDominateIn: java.util.Iterator[StoredNode]   = { java.util.Collections.emptyIterator() }
  def _reachingDefIn: java.util.Iterator[StoredNode]    = { java.util.Collections.emptyIterator() }
  def _receiverIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _refIn: java.util.Iterator[StoredNode]            = { java.util.Collections.emptyIterator() }
  def _sourceFileIn: java.util.Iterator[StoredNode]     = { java.util.Collections.emptyIterator() }
  def _taggedByIn: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _aliasOfOut: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _argumentOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _astOut: java.util.Iterator[StoredNode]           = { java.util.Collections.emptyIterator() }
  def _bindsOut: java.util.Iterator[StoredNode]         = { java.util.Collections.emptyIterator() }
  def _bindsToOut: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _callOut: java.util.Iterator[StoredNode]          = { java.util.Collections.emptyIterator() }
  def _captureOut: java.util.Iterator[StoredNode]       = { java.util.Collections.emptyIterator() }
  def _capturedByOut: java.util.Iterator[StoredNode]    = { java.util.Collections.emptyIterator() }
  def _cdgOut: java.util.Iterator[StoredNode]           = { java.util.Collections.emptyIterator() }
  def _cfgOut: java.util.Iterator[StoredNode]           = { java.util.Collections.emptyIterator() }
  def _conditionOut: java.util.Iterator[StoredNode]     = { java.util.Collections.emptyIterator() }
  def _containsOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _dominateOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _evalTypeOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _inheritsFromOut: java.util.Iterator[StoredNode]  = { java.util.Collections.emptyIterator() }
  def _parameterLinkOut: java.util.Iterator[StoredNode] = { java.util.Collections.emptyIterator() }
  def _pointsToOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _postDominateOut: java.util.Iterator[StoredNode]  = { java.util.Collections.emptyIterator() }
  def _reachingDefOut: java.util.Iterator[StoredNode]   = { java.util.Collections.emptyIterator() }
  def _receiverOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
  def _refOut: java.util.Iterator[StoredNode]           = { java.util.Collections.emptyIterator() }
  def _sourceFileOut: java.util.Iterator[StoredNode]    = { java.util.Collections.emptyIterator() }
  def _taggedByOut: java.util.Iterator[StoredNode]      = { java.util.Collections.emptyIterator() }
}

object Factories {
  lazy val all: Seq[NodeFactory[_]] = Seq(
    Annotation.factory,
    AnnotationLiteral.factory,
    AnnotationParameter.factory,
    AnnotationParameterAssign.factory,
    ArrayInitializer.factory,
    Binding.factory,
    Block.factory,
    Call.factory,
    ClosureBinding.factory,
    Comment.factory,
    ConfigFile.factory,
    ControlStructure.factory,
    Dependency.factory,
    FieldIdentifier.factory,
    File.factory,
    Finding.factory,
    Identifier.factory,
    Import.factory,
    JumpLabel.factory,
    JumpTarget.factory,
    KeyValuePair.factory,
    Literal.factory,
    Local.factory,
    Location.factory,
    Member.factory,
    MetaData.factory,
    Method.factory,
    MethodParameterIn.factory,
    MethodParameterOut.factory,
    MethodRef.factory,
    MethodReturn.factory,
    Modifier.factory,
    Namespace.factory,
    NamespaceBlock.factory,
    Return.factory,
    Tag.factory,
    TagNodePair.factory,
    TemplateDom.factory,
    Type.factory,
    TypeArgument.factory,
    TypeDecl.factory,
    TypeParameter.factory,
    TypeRef.factory,
    Unknown.factory
  )
  lazy val allAsJava: java.util.List[NodeFactory[_]] = all.asJava
}
