package io.shiftleft.codepropertygraph.generated.traversal

import overflowdb.traversal._
import io.shiftleft.codepropertygraph.generated.nodes._

/** Traversal steps for Type */
class TypeTraversalExtGen[NodeType <: Type](val traversal: IterableOnce[NodeType]) extends AnyVal {

  /** Direct alias type declarations. Traverse to TYPE_DECL via ALIAS_OF IN edge.
    */
  /** Direct alias type declarations. */
  @overflowdb.traversal.help.Doc(info = """Direct alias type declarations.""")
  def aliasTypeDecl: Traversal[TypeDecl] =
    traversal.flatMap(_.aliasTypeDecl)

  /** Type declaration which is referenced by this type. Traverse to TYPE_DECL via REF OUT edge.
    */
  /** Type declaration which is referenced by this type. */
  @overflowdb.traversal.help.Doc(info = """Type declaration which is referenced by this type.""")
  def referencedTypeDecl: Traversal[TypeDecl] =
    traversal.flatMap(_.referencedTypeDecl)

  /** Traverse to fullName property */
  def fullName: Traversal[String] =
    traversal.map(_.fullName)

  /** Traverse to nodes where the fullName matches the regular expression `value`
    */
  def fullName(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.fullName == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.fullName, pattern)
    }
  }

  /** Traverse to nodes where the fullName matches at least one of the regular expressions in `values`
    */
  def fullName(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.fullName, patterns)

  /** Traverse to nodes where fullName matches `value` exactly.
    */
  def fullNameExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.fullName == value }

  /** Traverse to nodes where fullName matches one of the elements in `values` exactly.
    */
  def fullNameExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.fullName) }
  }

  /** Traverse to nodes where fullName does not match the regular expression `value`.
    */
  def fullNameNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.fullName != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.fullName, pattern)
    }
  }

  /** Traverse to nodes where fullName does not match any of the regular expressions in `values`.
    */
  def fullNameNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.fullName, patterns)
  }

  /** Traverse to name property */
  def name: Traversal[String] =
    traversal.map(_.name)

  /** Traverse to nodes where the name matches the regular expression `value`
    */
  def name(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.name == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.name, pattern)
    }
  }

  /** Traverse to nodes where the name matches at least one of the regular expressions in `values`
    */
  def name(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.name, patterns)

  /** Traverse to nodes where name matches `value` exactly.
    */
  def nameExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.name == value }

  /** Traverse to nodes where name matches one of the elements in `values` exactly.
    */
  def nameExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.name) }
  }

  /** Traverse to nodes where name does not match the regular expression `value`.
    */
  def nameNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.name != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.name, pattern)
    }
  }

  /** Traverse to nodes where name does not match any of the regular expressions in `values`.
    */
  def nameNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.name, patterns)
  }

  /** Traverse to typeDeclFullName property */
  def typeDeclFullName: Traversal[String] =
    traversal.map(_.typeDeclFullName)

  /** Traverse to nodes where the typeDeclFullName matches the regular expression `value`
    */
  def typeDeclFullName(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.typeDeclFullName == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.typeDeclFullName, pattern)
    }
  }

  /** Traverse to nodes where the typeDeclFullName matches at least one of the regular expressions in `values`
    */
  def typeDeclFullName(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.typeDeclFullName, patterns)

  /** Traverse to nodes where typeDeclFullName matches `value` exactly.
    */
  def typeDeclFullNameExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.typeDeclFullName == value }

  /** Traverse to nodes where typeDeclFullName matches one of the elements in `values` exactly.
    */
  def typeDeclFullNameExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.typeDeclFullName) }
  }

  /** Traverse to nodes where typeDeclFullName does not match the regular expression `value`.
    */
  def typeDeclFullNameNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.typeDeclFullName != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.typeDeclFullName, pattern)
    }
  }

  /** Traverse to nodes where typeDeclFullName does not match any of the regular expressions in `values`.
    */
  def typeDeclFullNameNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.typeDeclFullName, patterns)
  }

}
