package io.shiftleft.codepropertygraph.generated.traversal

import overflowdb.traversal._
import io.shiftleft.codepropertygraph.generated.nodes._

/** Traversal steps for MetaData */
class MetaDataTraversalExtGen[NodeType <: MetaData](val traversal: IterableOnce[NodeType]) extends AnyVal {

  /** Traverse to hash property */
  def hash: Traversal[String] =
    traversal.flatMap(_.hash)

  /** Traverse to nodes where the hash matches the regular expression `value`
    */
  def hash(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.hash.isDefined && node.hash.get == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal.filter(_.hash.isDefined))(_.hash.get, pattern)
    }
  }

  /** Traverse to nodes where the hash matches at least one of the regular expressions in `values`
    */
  def hash(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter
      .regexpMultiple(traversal.filter(_.hash.isDefined))(_.hash.get, patterns)
  }

  /** Traverse to nodes where hash matches `value` exactly.
    */
  def hashExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.hash.isDefined && node.hash.get == value }

  /** Traverse to nodes where hash matches one of the elements in `values` exactly.
    */
  def hashExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => node.hash.isDefined && vset.contains(node.hash.get) }
  }

  /** Traverse to nodes where hash does not match the regular expression `value`.
    */
  def hashNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.hash.isEmpty || node.hash.get != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter
        .regexpNot(traversal.filter(_.hash.isDefined))(_.hash.get, pattern)
    }
  }

  /** Traverse to nodes where hash does not match any of the regular expressions in `values`.
    */
  def hashNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter
      .regexpNotMultiple(traversal.filter(_.hash.isDefined))(_.hash.get, patterns)
  }

  /** Traverse to language property */
  def language: Traversal[String] =
    traversal.map(_.language)

  /** Traverse to nodes where the language matches the regular expression `value`
    */
  def language(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.language == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.language, pattern)
    }
  }

  /** Traverse to nodes where the language matches at least one of the regular expressions in `values`
    */
  def language(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.language, patterns)

  /** Traverse to nodes where language matches `value` exactly.
    */
  def languageExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.language == value }

  /** Traverse to nodes where language matches one of the elements in `values` exactly.
    */
  def languageExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.language) }
  }

  /** Traverse to nodes where language does not match the regular expression `value`.
    */
  def languageNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.language != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.language, pattern)
    }
  }

  /** Traverse to nodes where language does not match any of the regular expressions in `values`.
    */
  def languageNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.language, patterns)
  }

  /** Traverse to overlays property */
  def overlays: Traversal[String] =
    traversal.flatMap(_.overlays)

  /** Traverse to version property */
  def version: Traversal[String] =
    traversal.map(_.version)

  /** Traverse to nodes where the version matches the regular expression `value`
    */
  def version(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.version == pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexp(traversal)(_.version, pattern)
    }
  }

  /** Traverse to nodes where the version matches at least one of the regular expressions in `values`
    */
  def version(patterns: String*): Traversal[NodeType] =
    overflowdb.traversal.filter.StringPropertyFilter.regexpMultiple(traversal)(_.version, patterns)

  /** Traverse to nodes where version matches `value` exactly.
    */
  def versionExact(value: String): Traversal[NodeType] =
    traversal.filter { node => node.version == value }

  /** Traverse to nodes where version matches one of the elements in `values` exactly.
    */
  def versionExact(values: String*): Traversal[NodeType] = {
    val vset = values.to(Set)
    traversal.filter { node => vset.contains(node.version) }
  }

  /** Traverse to nodes where version does not match the regular expression `value`.
    */
  def versionNot(pattern: String): Traversal[NodeType] = {
    if (!Misc.isRegex(pattern)) {
      traversal.filter { node => node.version != pattern }
    } else {
      overflowdb.traversal.filter.StringPropertyFilter.regexpNot(traversal)(_.version, pattern)
    }
  }

  /** Traverse to nodes where version does not match any of the regular expressions in `values`.
    */
  def versionNot(patterns: String*): Traversal[NodeType] = {
    overflowdb.traversal.filter.StringPropertyFilter.regexpNotMultiple(traversal)(_.version, patterns)
  }

}
