package io.shiftleft.codepropertygraph.generated.nodes

object Expression {
  object PropertyNames {
    val ArgumentIndex    = "ARGUMENT_INDEX"
    val ArgumentName     = "ARGUMENT_NAME"
    val Code             = "CODE"
    val ColumnNumber     = "COLUMN_NUMBER"
    val LineNumber       = "LINE_NUMBER"
    val Order            = "ORDER"
    val all: Set[String] = Set(ArgumentIndex, ArgumentName, Code, ColumnNumber, LineNumber, Order)
  }

  object Properties {
    val ArgumentIndex = new overflowdb.PropertyKey[scala.Int]("ARGUMENT_INDEX")
    val ArgumentName  = new overflowdb.PropertyKey[String]("ARGUMENT_NAME")
    val Code          = new overflowdb.PropertyKey[String]("CODE")
    val ColumnNumber  = new overflowdb.PropertyKey[Integer]("COLUMN_NUMBER")
    val LineNumber    = new overflowdb.PropertyKey[Integer]("LINE_NUMBER")
    val Order         = new overflowdb.PropertyKey[scala.Int]("ORDER")
  }

  object PropertyDefaults {
    val ArgumentIndex = -1: Int
    val Code          = "<empty>"
    val Order         = -1: Int
  }

  object Edges {
    val Out: Array[String] = Array()
    val In: Array[String]  = Array()
  }

}

trait ExpressionBase
    extends AbstractNode
    with HasArgumentIndex
    with HasArgumentName
    with HasCode
    with HasColumnNumber
    with HasLineNumber
    with HasOrder
    with AstNodeBase
    with CfgNodeBase

trait ExpressionNew
    extends NewNode
    with HasArgumentIndexMutable
    with HasArgumentNameMutable
    with HasCodeMutable
    with HasColumnNumberMutable
    with HasLineNumberMutable
    with HasOrderMutable
    with AstNodeNew
    with CfgNodeNew

trait Expression extends StoredNode with ExpressionBase with AstNode with CfgNode {}
