package io.shiftleft.codepropertygraph.generated.nodes

import overflowdb._
import scala.jdk.CollectionConverters._

object Annotation {
  def apply(graph: Graph, id: Long) = new Annotation(graph, id)

  val Label = "ANNOTATION"

  object PropertyNames {
    val ArgumentIndex    = "ARGUMENT_INDEX"
    val ArgumentName     = "ARGUMENT_NAME"
    val Code             = "CODE"
    val ColumnNumber     = "COLUMN_NUMBER"
    val FullName         = "FULL_NAME"
    val LineNumber       = "LINE_NUMBER"
    val Name             = "NAME"
    val Order            = "ORDER"
    val all: Set[String] = Set(ArgumentIndex, ArgumentName, Code, ColumnNumber, FullName, LineNumber, Name, Order)
    val allAsJava: java.util.Set[String] = all.asJava
  }

  object Properties {
    val ArgumentIndex = new overflowdb.PropertyKey[scala.Int]("ARGUMENT_INDEX")
    val ArgumentName  = new overflowdb.PropertyKey[String]("ARGUMENT_NAME")
    val Code          = new overflowdb.PropertyKey[String]("CODE")
    val ColumnNumber  = new overflowdb.PropertyKey[Integer]("COLUMN_NUMBER")
    val FullName      = new overflowdb.PropertyKey[String]("FULL_NAME")
    val LineNumber    = new overflowdb.PropertyKey[Integer]("LINE_NUMBER")
    val Name          = new overflowdb.PropertyKey[String]("NAME")
    val Order         = new overflowdb.PropertyKey[scala.Int]("ORDER")

  }

  object PropertyDefaults {
    val ArgumentIndex = -1: Int
    val Code          = "<empty>"
    val FullName      = "<empty>"
    val Name          = "<empty>"
    val Order         = -1: Int
  }

  val layoutInformation = new NodeLayoutInformation(
    Label,
    PropertyNames.allAsJava,
    List(
      io.shiftleft.codepropertygraph.generated.edges.Ast.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.DataFlow.layoutInformation
    ).asJava,
    List(
      io.shiftleft.codepropertygraph.generated.edges.Ast.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.DataFlow.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Cfg.layoutInformation
    ).asJava
  )

  object Edges {
    val Out: Array[String] = Array("AST", "DATA_FLOW")
    val In: Array[String]  = Array("AST", "CFG", "DATA_FLOW")
  }

  val factory = new NodeFactory[AnnotationDb] {
    override val forLabel = Annotation.Label

    override def createNode(ref: NodeRef[AnnotationDb]) =
      new AnnotationDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = Annotation(graph, id)
  }
}

trait AnnotationBase
    extends AbstractNode
    with ExpressionBase
    with HasArgumentIndex
    with HasArgumentName
    with HasCode
    with HasColumnNumber
    with HasFullName
    with HasLineNumber
    with HasName
    with HasOrder {
  def asStored: StoredNode = this.asInstanceOf[StoredNode]

}

class Annotation(graph: Graph, id: Long)
    extends NodeRef[AnnotationDb](graph, id)
    with AnnotationBase
    with StoredNode
    with Expression {
  override def argumentIndex: scala.Int      = get().argumentIndex
  override def argumentName: Option[String]  = get().argumentName
  override def code: String                  = get().code
  override def columnNumber: Option[Integer] = get().columnNumber
  override def fullName: String              = get().fullName
  override def lineNumber: Option[Integer]   = get().lineNumber
  override def name: String                  = get().name
  override def order: scala.Int              = get().order
  override def propertyDefaultValue(propertyKey: String) =
    propertyKey match {
      case "ARGUMENT_INDEX" => Annotation.PropertyDefaults.ArgumentIndex
      case "CODE"           => Annotation.PropertyDefaults.Code
      case "FULL_NAME"      => Annotation.PropertyDefaults.FullName
      case "NAME"           => Annotation.PropertyDefaults.Name
      case "ORDER"          => Annotation.PropertyDefaults.Order
      case _                => super.propertyDefaultValue(propertyKey)
    }

  def astOut: overflowdb.traversal.Traversal[AnnotationParameterAssign] = get().astOut
  override def _astOut                                                  = get()._astOut

  /** Traverse to ANNOTATION_PARAMETER_ASSIGN via AST OUT edge.
    */
  def _annotationParameterAssignViaAstOut: overflowdb.traversal.Traversal[AnnotationParameterAssign] =
    get()._annotationParameterAssignViaAstOut

  def dataFlowOut: overflowdb.traversal.Traversal[CfgNode] = get().dataFlowOut
  override def _dataFlowOut                                = get()._dataFlowOut

  def astIn: overflowdb.traversal.Traversal[AstNode] = get().astIn
  override def _astIn                                = get()._astIn

  /** Traverse to MEMBER via AST IN edge.
    */
  def _memberViaAstIn: overflowdb.traversal.Traversal[Member] = get()._memberViaAstIn

  /** Traverse to METHOD_PARAMETER_IN via AST IN edge.
    */
  def _methodParameterInViaAstIn: overflowdb.traversal.Traversal[MethodParameterIn] = get()._methodParameterInViaAstIn

  /** Traverse to ANNOTATION_PARAMETER_ASSIGN via AST IN edge.
    */
  def _annotationParameterAssignViaAstIn: overflowdb.traversal.Traversal[AnnotationParameterAssign] =
    get()._annotationParameterAssignViaAstIn

  /** Traverse to METHOD via AST IN edge.
    */
  def _methodViaAstIn: overflowdb.traversal.Traversal[Method] = get()._methodViaAstIn

  /** Traverse to TYPE_DECL via AST IN edge.
    */
  def _typeDeclViaAstIn: overflowdb.traversal.Traversal[TypeDecl] = get()._typeDeclViaAstIn

  def dataFlowIn: overflowdb.traversal.Traversal[CfgNode] = get().dataFlowIn
  override def _dataFlowIn                                = get()._dataFlowIn

  def cfgIn: overflowdb.traversal.Traversal[CfgNode] = get().cfgIn
  override def _cfgIn                                = get()._cfgIn

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def canEqual(that: Any): Boolean                                        = get.canEqual(that)
  override def label: String = {
    Annotation.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id"
      case 1 => "argumentIndex"
      case 2 => "argumentName"
      case 3 => "code"
      case 4 => "columnNumber"
      case 5 => "fullName"
      case 6 => "lineNumber"
      case 7 => "name"
      case 8 => "order"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
      case 1 => argumentIndex
      case 2 => argumentName
      case 3 => code
      case 4 => columnNumber
      case 5 => fullName
      case 6 => lineNumber
      case 7 => name
      case 8 => order
    }

  override def productPrefix = "Annotation"
  override def productArity  = 9
}

class AnnotationDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode with Expression with AnnotationBase {

  override def layoutInformation: NodeLayoutInformation = Annotation.layoutInformation

  private var _argumentIndex: scala.Int = Annotation.PropertyDefaults.ArgumentIndex
  def argumentIndex: scala.Int          = _argumentIndex
  private var _argumentName: String     = null
  def argumentName: Option[String]      = Option(_argumentName)
  private var _code: String             = Annotation.PropertyDefaults.Code
  def code: String                      = _code
  private var _columnNumber: Integer    = null
  def columnNumber: Option[Integer]     = Option(_columnNumber)
  private var _fullName: String         = Annotation.PropertyDefaults.FullName
  def fullName: String                  = _fullName
  private var _lineNumber: Integer      = null
  def lineNumber: Option[Integer]       = Option(_lineNumber)
  private var _name: String             = Annotation.PropertyDefaults.Name
  def name: String                      = _name
  private var _order: scala.Int         = Annotation.PropertyDefaults.Order
  def order: scala.Int                  = _order

  /** faster than the default implementation */
  override def propertiesMap: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    properties.put("ARGUMENT_INDEX", argumentIndex)
    argumentName.map { value => properties.put("ARGUMENT_NAME", value) }
    properties.put("CODE", code)
    columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
    properties.put("FULL_NAME", fullName)
    lineNumber.map { value => properties.put("LINE_NUMBER", value) }
    properties.put("NAME", name)
    properties.put("ORDER", order)

    properties
  }

  /** faster than the default implementation */
  override def propertiesMapForStorage: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    if (!((-1: Int) == argumentIndex)) { properties.put("ARGUMENT_INDEX", argumentIndex) }
    argumentName.map { value => properties.put("ARGUMENT_NAME", value) }
    if (!(("<empty>") == code)) { properties.put("CODE", code) }
    columnNumber.map { value => properties.put("COLUMN_NUMBER", value) }
    if (!(("<empty>") == fullName)) { properties.put("FULL_NAME", fullName) }
    lineNumber.map { value => properties.put("LINE_NUMBER", value) }
    if (!(("<empty>") == name)) { properties.put("NAME", name) }
    if (!((-1: Int) == order)) { properties.put("ORDER", order) }

    properties
  }

  def astOut: overflowdb.traversal.Traversal[AnnotationParameterAssign] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[AnnotationParameterAssign](0))
  override def _astOut = createAdjacentNodeIteratorByOffSet[StoredNode](0)
  def _annotationParameterAssignViaAstOut: overflowdb.traversal.Traversal[AnnotationParameterAssign] =
    astOut.collectAll[AnnotationParameterAssign]

  def dataFlowOut: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](1))
  override def _dataFlowOut = createAdjacentNodeIteratorByOffSet[StoredNode](1)

  def astIn: overflowdb.traversal.Traversal[AstNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[AstNode](2))
  override def _astIn                                         = createAdjacentNodeIteratorByOffSet[StoredNode](2)
  def _memberViaAstIn: overflowdb.traversal.Traversal[Member] = astIn.collectAll[Member]
  def _methodParameterInViaAstIn: overflowdb.traversal.Traversal[MethodParameterIn] =
    astIn.collectAll[MethodParameterIn]
  def _annotationParameterAssignViaAstIn: overflowdb.traversal.Traversal[AnnotationParameterAssign] =
    astIn.collectAll[AnnotationParameterAssign]
  def _methodViaAstIn: overflowdb.traversal.Traversal[Method]     = astIn.collectAll[Method]
  def _typeDeclViaAstIn: overflowdb.traversal.Traversal[TypeDecl] = astIn.collectAll[TypeDecl]

  def dataFlowIn: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](3))
  override def _dataFlowIn = createAdjacentNodeIteratorByOffSet[StoredNode](3)

  def cfgIn: overflowdb.traversal.Traversal[CfgNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[CfgNode](4))
  override def _cfgIn = createAdjacentNodeIteratorByOffSet[StoredNode](4)

  override def label: String = {
    Annotation.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id"
      case 1 => "argumentIndex"
      case 2 => "argumentName"
      case 3 => "code"
      case 4 => "columnNumber"
      case 5 => "fullName"
      case 6 => "lineNumber"
      case 7 => "name"
      case 8 => "order"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
      case 1 => argumentIndex
      case 2 => argumentName
      case 3 => code
      case 4 => columnNumber
      case 5 => fullName
      case 6 => lineNumber
      case 7 => name
      case 8 => order
    }

  override def productPrefix = "Annotation"
  override def productArity  = 9

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[AnnotationDb]

  override def property(key: String): Any = {
    key match {
      case "ARGUMENT_INDEX" => this._argumentIndex
      case "ARGUMENT_NAME"  => this._argumentName
      case "CODE"           => this._code
      case "COLUMN_NUMBER"  => this._columnNumber
      case "FULL_NAME"      => this._fullName
      case "LINE_NUMBER"    => this._lineNumber
      case "NAME"           => this._name
      case "ORDER"          => this._order

      case _ => null
    }
  }

  override protected def updateSpecificProperty(key: String, value: Object): Unit = {
    key match {
      case "ARGUMENT_INDEX" => this._argumentIndex = value.asInstanceOf[scala.Int]
      case "ARGUMENT_NAME"  => this._argumentName = value.asInstanceOf[String]
      case "CODE"           => this._code = value.asInstanceOf[String]
      case "COLUMN_NUMBER"  => this._columnNumber = value.asInstanceOf[Integer]
      case "FULL_NAME"      => this._fullName = value.asInstanceOf[String]
      case "LINE_NUMBER"    => this._lineNumber = value.asInstanceOf[Integer]
      case "NAME"           => this._name = value.asInstanceOf[String]
      case "ORDER"          => this._order = value.asInstanceOf[scala.Int]

      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

  override def removeSpecificProperty(key: String): Unit =
    this.updateSpecificProperty(key, null)

  override def _initializeFromDetached(
    data: overflowdb.DetachedNodeData,
    mapper: java.util.function.Function[overflowdb.DetachedNodeData, Node]
  ) =
    fromNewNode(data.asInstanceOf[NewNode], nn => mapper.apply(nn).asInstanceOf[StoredNode])

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = {
    this._argumentIndex = newNode.asInstanceOf[NewAnnotation].argumentIndex
    this._argumentName = newNode.asInstanceOf[NewAnnotation].argumentName.orNull
    this._code = newNode.asInstanceOf[NewAnnotation].code
    this._columnNumber = newNode.asInstanceOf[NewAnnotation].columnNumber.orNull
    this._fullName = newNode.asInstanceOf[NewAnnotation].fullName
    this._lineNumber = newNode.asInstanceOf[NewAnnotation].lineNumber.orNull
    this._name = newNode.asInstanceOf[NewAnnotation].name
    this._order = newNode.asInstanceOf[NewAnnotation].order

    graph.indexManager.putIfIndexed("FULL_NAME", newNode.asInstanceOf[NewAnnotation].fullName, this.ref)
  }

}
