package io.shiftleft.codepropertygraph.generated.nodes

import overflowdb._
import scala.jdk.CollectionConverters._

object ClosureBinding {
  def apply(graph: Graph, id: Long) = new ClosureBinding(graph, id)

  val Label = "CLOSURE_BINDING"

  object PropertyNames {
    val ClosureBindingId                 = "CLOSURE_BINDING_ID"
    val ClosureOriginalName              = "CLOSURE_ORIGINAL_NAME"
    val EvaluationStrategy               = "EVALUATION_STRATEGY"
    val all: Set[String]                 = Set(ClosureBindingId, ClosureOriginalName, EvaluationStrategy)
    val allAsJava: java.util.Set[String] = all.asJava
  }

  object Properties {
    val ClosureBindingId    = new overflowdb.PropertyKey[String]("CLOSURE_BINDING_ID")
    val ClosureOriginalName = new overflowdb.PropertyKey[String]("CLOSURE_ORIGINAL_NAME")
    val EvaluationStrategy  = new overflowdb.PropertyKey[String]("EVALUATION_STRATEGY")

  }

  object PropertyDefaults {
    val EvaluationStrategy = "<empty>"
  }

  val layoutInformation = new NodeLayoutInformation(
    Label,
    PropertyNames.allAsJava,
    List(io.shiftleft.codepropertygraph.generated.edges.Ref.layoutInformation).asJava,
    List(
      io.shiftleft.codepropertygraph.generated.edges.CapturedBy.layoutInformation,
      io.shiftleft.codepropertygraph.generated.edges.Capture.layoutInformation
    ).asJava
  )

  object Edges {
    val Out: Array[String] = Array("REF")
    val In: Array[String]  = Array("CAPTURE", "CAPTURED_BY")
  }

  val factory = new NodeFactory[ClosureBindingDb] {
    override val forLabel = ClosureBinding.Label

    override def createNode(ref: NodeRef[ClosureBindingDb]) =
      new ClosureBindingDb(ref.asInstanceOf[NodeRef[NodeDb]])

    override def createNodeRef(graph: Graph, id: Long) = ClosureBinding(graph, id)
  }
}

trait ClosureBindingBase
    extends AbstractNode
    with HasClosureBindingId
    with HasClosureOriginalName
    with HasEvaluationStrategy {
  def asStored: StoredNode = this.asInstanceOf[StoredNode]

}

class ClosureBinding(graph: Graph, id: Long)
    extends NodeRef[ClosureBindingDb](graph, id)
    with ClosureBindingBase
    with StoredNode {
  override def closureBindingId: Option[String]    = get().closureBindingId
  override def closureOriginalName: Option[String] = get().closureOriginalName
  override def evaluationStrategy: String          = get().evaluationStrategy
  override def propertyDefaultValue(propertyKey: String) =
    propertyKey match {
      case "EVALUATION_STRATEGY" => ClosureBinding.PropertyDefaults.EvaluationStrategy
      case _                     => super.propertyDefaultValue(propertyKey)
    }

  def refOut: overflowdb.traversal.Traversal[AstNode] = get().refOut
  override def _refOut                                = get()._refOut

  /** Traverse to LOCAL via REF OUT edge.
    */
  def _localViaRefOut: Local = get()._localViaRefOut

  /** Traverse to METHOD_PARAMETER_IN via REF OUT edge.
    */
  def _methodParameterInViaRefOut: overflowdb.traversal.Traversal[MethodParameterIn] = get()._methodParameterInViaRefOut

  def capturedByIn: overflowdb.traversal.Traversal[Local] = get().capturedByIn
  override def _capturedByIn                              = get()._capturedByIn

  /** Traverse to LOCAL via CAPTURED_BY IN edge.
    */
  def _localViaCapturedByIn: overflowdb.traversal.Traversal[Local] = get()._localViaCapturedByIn

  def captureIn: overflowdb.traversal.Traversal[Expression] = get().captureIn
  override def _captureIn                                   = get()._captureIn

  /** Traverse to TYPE_REF via CAPTURE IN edge.
    */
  def _typeRefViaCaptureIn: overflowdb.traversal.Traversal[TypeRef] = get()._typeRefViaCaptureIn

  /** Traverse to METHOD_REF via CAPTURE IN edge.
    */
  def _methodRefViaCaptureIn: overflowdb.traversal.Traversal[MethodRef] = get()._methodRefViaCaptureIn

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = get().fromNewNode(newNode, mapping)
  override def canEqual(that: Any): Boolean                                        = get.canEqual(that)
  override def label: String = {
    ClosureBinding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id"
      case 1 => "closureBindingId"
      case 2 => "closureOriginalName"
      case 3 => "evaluationStrategy"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
      case 1 => closureBindingId
      case 2 => closureOriginalName
      case 3 => evaluationStrategy
    }

  override def productPrefix = "ClosureBinding"
  override def productArity  = 4
}

class ClosureBindingDb(ref: NodeRef[NodeDb]) extends NodeDb(ref) with StoredNode with ClosureBindingBase {

  override def layoutInformation: NodeLayoutInformation = ClosureBinding.layoutInformation

  private var _closureBindingId: String    = null
  def closureBindingId: Option[String]     = Option(_closureBindingId)
  private var _closureOriginalName: String = null
  def closureOriginalName: Option[String]  = Option(_closureOriginalName)
  private var _evaluationStrategy: String  = ClosureBinding.PropertyDefaults.EvaluationStrategy
  def evaluationStrategy: String           = _evaluationStrategy

  /** faster than the default implementation */
  override def propertiesMap: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    closureBindingId.map { value => properties.put("CLOSURE_BINDING_ID", value) }
    closureOriginalName.map { value => properties.put("CLOSURE_ORIGINAL_NAME", value) }
    properties.put("EVALUATION_STRATEGY", evaluationStrategy)

    properties
  }

  /** faster than the default implementation */
  override def propertiesMapForStorage: java.util.Map[String, Any] = {
    val properties = new java.util.HashMap[String, Any]
    closureBindingId.map { value => properties.put("CLOSURE_BINDING_ID", value) }
    closureOriginalName.map { value => properties.put("CLOSURE_ORIGINAL_NAME", value) }
    if (!(("<empty>") == evaluationStrategy)) { properties.put("EVALUATION_STRATEGY", evaluationStrategy) }

    properties
  }

  def refOut: overflowdb.traversal.Traversal[AstNode] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[AstNode](0))
  override def _refOut = createAdjacentNodeIteratorByOffSet[StoredNode](0)
  def _localViaRefOut: Local = try { refOut.collectAll[Local].next() }
  catch {
    case e: java.util.NoSuchElementException =>
      throw new overflowdb.SchemaViolationException(
        "OUT edge with label REF to an adjacent LOCAL is mandatory, but not defined for this CLOSURE_BINDING node with id=" + id,
        e
      )
  }
  def _methodParameterInViaRefOut: overflowdb.traversal.Traversal[MethodParameterIn] =
    refOut.collectAll[MethodParameterIn]

  def capturedByIn: overflowdb.traversal.Traversal[Local] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Local](1))
  override def _capturedByIn                                       = createAdjacentNodeIteratorByOffSet[StoredNode](1)
  def _localViaCapturedByIn: overflowdb.traversal.Traversal[Local] = capturedByIn.collectAll[Local]

  def captureIn: overflowdb.traversal.Traversal[Expression] =
    overflowdb.traversal.Traversal(createAdjacentNodeIteratorByOffSet[Expression](2))
  override def _captureIn                                           = createAdjacentNodeIteratorByOffSet[StoredNode](2)
  def _typeRefViaCaptureIn: overflowdb.traversal.Traversal[TypeRef] = captureIn.collectAll[TypeRef]
  def _methodRefViaCaptureIn: overflowdb.traversal.Traversal[MethodRef] = captureIn.collectAll[MethodRef]

  override def label: String = {
    ClosureBinding.Label
  }

  override def productElementLabel(n: Int): String =
    n match {
      case 0 => "id"
      case 1 => "closureBindingId"
      case 2 => "closureOriginalName"
      case 3 => "evaluationStrategy"
    }

  override def productElement(n: Int): Any =
    n match {
      case 0 => id
      case 1 => closureBindingId
      case 2 => closureOriginalName
      case 3 => evaluationStrategy
    }

  override def productPrefix = "ClosureBinding"
  override def productArity  = 4

  override def canEqual(that: Any): Boolean = that != null && that.isInstanceOf[ClosureBindingDb]

  override def property(key: String): Any = {
    key match {
      case "CLOSURE_BINDING_ID"    => this._closureBindingId
      case "CLOSURE_ORIGINAL_NAME" => this._closureOriginalName
      case "EVALUATION_STRATEGY"   => this._evaluationStrategy

      case _ => null
    }
  }

  override protected def updateSpecificProperty(key: String, value: Object): Unit = {
    key match {
      case "CLOSURE_BINDING_ID"    => this._closureBindingId = value.asInstanceOf[String]
      case "CLOSURE_ORIGINAL_NAME" => this._closureOriginalName = value.asInstanceOf[String]
      case "EVALUATION_STRATEGY"   => this._evaluationStrategy = value.asInstanceOf[String]

      case _ => PropertyErrorRegister.logPropertyErrorIfFirst(getClass, key)
    }
  }

  override def removeSpecificProperty(key: String): Unit =
    this.updateSpecificProperty(key, null)

  override def _initializeFromDetached(
    data: overflowdb.DetachedNodeData,
    mapper: java.util.function.Function[overflowdb.DetachedNodeData, Node]
  ) =
    fromNewNode(data.asInstanceOf[NewNode], nn => mapper.apply(nn).asInstanceOf[StoredNode])

  override def fromNewNode(newNode: NewNode, mapping: NewNode => StoredNode): Unit = {
    this._closureBindingId = newNode.asInstanceOf[NewClosureBinding].closureBindingId.orNull
    this._closureOriginalName = newNode.asInstanceOf[NewClosureBinding].closureOriginalName.orNull
    this._evaluationStrategy = newNode.asInstanceOf[NewClosureBinding].evaluationStrategy

  }

}
