package io.shiftleft.codepropertygraph.generated.nodes

object CallRepr {
  object PropertyNames {
    val Code             = "CODE"
    val ColumnNumber     = "COLUMN_NUMBER"
    val LineNumber       = "LINE_NUMBER"
    val Name             = "NAME"
    val Order            = "ORDER"
    val Signature        = "SIGNATURE"
    val all: Set[String] = Set(Code, ColumnNumber, LineNumber, Name, Order, Signature)
  }

  object Properties {
    val Code         = new overflowdb.PropertyKey[String]("CODE")
    val ColumnNumber = new overflowdb.PropertyKey[Integer]("COLUMN_NUMBER")
    val LineNumber   = new overflowdb.PropertyKey[Integer]("LINE_NUMBER")
    val Name         = new overflowdb.PropertyKey[String]("NAME")
    val Order        = new overflowdb.PropertyKey[scala.Int]("ORDER")
    val Signature    = new overflowdb.PropertyKey[String]("SIGNATURE")
  }

  object PropertyDefaults {
    val Code      = "<empty>"
    val Name      = "<empty>"
    val Order     = -1: Int
    val Signature = ""
  }

  object Edges {
    val Out: Array[String] = Array()
    val In: Array[String]  = Array()
  }

}

trait CallReprBase
    extends AbstractNode
    with HasCode
    with HasColumnNumber
    with HasLineNumber
    with HasName
    with HasOrder
    with HasSignature
    with CfgNodeBase

trait CallReprNew
    extends NewNode
    with HasCodeMutable
    with HasColumnNumberMutable
    with HasLineNumberMutable
    with HasNameMutable
    with HasOrderMutable
    with HasSignatureMutable
    with CfgNodeNew

trait CallRepr extends StoredNode with CallReprBase with CfgNode {}
