/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.transaction.bed;

import com.dangdang.ddframe.job.api.JobConfiguration;
import com.dangdang.ddframe.job.api.JobScheduler;
import com.dangdang.ddframe.job.api.listener.ElasticJobListener;
import com.dangdang.ddframe.reg.base.CoordinatorRegistryCenter;
import com.dangdang.ddframe.reg.zookeeper.ZookeeperConfiguration;
import com.dangdang.ddframe.reg.zookeeper.ZookeeperRegistryCenter;
import io.shardingjdbc.transaction.bed.BestEffortsDeliveryConfiguration;
import io.shardingjdbc.transaction.bed.BestEffortsDeliveryJob;
import io.shardingjdbc.transaction.config.AsyncSoftTransactionZookeeperConfiguration;
import io.shardingjdbc.transaction.datasource.TransactionLogDataSource;
import io.shardingjdbc.transaction.datasource.impl.RdbTransactionLogDataSource;
import io.shardingjdbc.transaction.storage.TransactionLogStorageFactory;
import java.beans.ConstructorProperties;

public final class BestEffortsDeliveryJobFactory {
    private final BestEffortsDeliveryConfiguration bedConfig;

    public void init() {
        ZookeeperRegistryCenter regCenter = new ZookeeperRegistryCenter(this.createZookeeperConfiguration(this.bedConfig));
        regCenter.init();
        JobScheduler jobScheduler = new JobScheduler((CoordinatorRegistryCenter)regCenter, this.createBedJobConfiguration(this.bedConfig), new ElasticJobListener[0]);
        jobScheduler.setField("bedConfig", (Object)this.bedConfig);
        jobScheduler.setField("transactionLogStorage", (Object)TransactionLogStorageFactory.createTransactionLogStorage((TransactionLogDataSource)new RdbTransactionLogDataSource(this.bedConfig.getDefaultTransactionLogDataSource())));
        jobScheduler.init();
    }

    public ZookeeperConfiguration createZookeeperConfiguration(BestEffortsDeliveryConfiguration bedConfig) {
        AsyncSoftTransactionZookeeperConfiguration zkConfig = bedConfig.getZkConfig();
        return new ZookeeperConfiguration(zkConfig.getConnectionString(), zkConfig.getNamespace(), zkConfig.getBaseSleepTimeMilliseconds(), zkConfig.getMaxSleepTimeMilliseconds(), zkConfig.getMaxRetries());
    }

    private JobConfiguration createBedJobConfiguration(BestEffortsDeliveryConfiguration bedJobConfig) {
        JobConfiguration result = new JobConfiguration(bedJobConfig.getJobConfig().getName(), BestEffortsDeliveryJob.class, 1, bedJobConfig.getJobConfig().getCron());
        result.setFetchDataCount(bedJobConfig.getJobConfig().getTransactionLogFetchDataCount());
        result.setOverwrite(true);
        return result;
    }

    @ConstructorProperties(value={"bedConfig"})
    public BestEffortsDeliveryJobFactory(BestEffortsDeliveryConfiguration bedConfig) {
        this.bedConfig = bedConfig;
    }
}

