/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.transaction.bed;

import com.dangdang.ddframe.job.api.JobExecutionMultipleShardingContext;
import com.dangdang.ddframe.job.plugin.job.type.dataflow.AbstractIndividualThroughputDataFlowElasticJob;
import io.shardingjdbc.transaction.bed.BestEffortsDeliveryConfiguration;
import io.shardingjdbc.transaction.exception.TransactionCompensationException;
import io.shardingjdbc.transaction.storage.TransactionLog;
import io.shardingjdbc.transaction.storage.TransactionLogStorage;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestEffortsDeliveryJob
extends AbstractIndividualThroughputDataFlowElasticJob<TransactionLog> {
    private static final Logger log = LoggerFactory.getLogger(BestEffortsDeliveryJob.class);
    private BestEffortsDeliveryConfiguration bedConfig;
    private TransactionLogStorage transactionLogStorage;

    public List<TransactionLog> fetchData(JobExecutionMultipleShardingContext context) {
        return this.transactionLogStorage.findEligibleTransactionLogs(context.getFetchDataCount(), this.bedConfig.getJobConfig().getMaxDeliveryTryTimes(), this.bedConfig.getJobConfig().getMaxDeliveryTryDelayMillis());
    }

    public boolean processData(JobExecutionMultipleShardingContext context, TransactionLog data) {
        try (Connection conn = this.bedConfig.getTargetDataSource(data.getDataSource()).getConnection();){
            this.transactionLogStorage.processData(conn, data, this.bedConfig.getJobConfig().getMaxDeliveryTryTimes());
        }
        catch (TransactionCompensationException | SQLException ex) {
            log.error(String.format("Async delivery times %s error, max try times is %s, exception is %s", data.getAsyncDeliveryTryTimes() + 1, this.bedConfig.getJobConfig().getMaxDeliveryTryTimes(), ex.getMessage()));
            return false;
        }
        return true;
    }

    public boolean isStreamingProcess() {
        return false;
    }

    public void setBedConfig(BestEffortsDeliveryConfiguration bedConfig) {
        this.bedConfig = bedConfig;
    }

    public void setTransactionLogStorage(TransactionLogStorage transactionLogStorage) {
        this.transactionLogStorage = transactionLogStorage;
    }
}

