/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.state.instance;

import io.shardingjdbc.core.exception.ShardingJdbcException;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.internal.config.ConfigurationService;
import io.shardingjdbc.orchestration.internal.jdbc.datasource.CircuitBreakerDataSource;
import io.shardingjdbc.orchestration.internal.listener.ListenerManager;
import io.shardingjdbc.orchestration.internal.state.StateNode;
import io.shardingjdbc.orchestration.internal.state.StateNodeStatus;
import io.shardingjdbc.orchestration.internal.state.instance.OrchestrationInstance;
import io.shardingjdbc.orchestration.reg.api.RegistryCenter;
import io.shardingjdbc.orchestration.reg.listener.DataChangedEvent;
import io.shardingjdbc.orchestration.reg.listener.EventListener;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;

public final class InstanceListenerManager
implements ListenerManager {
    private final StateNode stateNode;
    private final RegistryCenter regCenter;
    private final ConfigurationService configService;

    public InstanceListenerManager(String name, RegistryCenter regCenter) {
        this.stateNode = new StateNode(name);
        this.regCenter = regCenter;
        this.configService = new ConfigurationService(name, regCenter);
    }

    @Override
    public void start(final ShardingDataSource shardingDataSource) {
        this.regCenter.watch(this.stateNode.getInstancesNodeFullPath(new OrchestrationInstance().getInstanceId()), new EventListener(){

            @Override
            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    Map<String, DataSource> dataSourceMap = InstanceListenerManager.this.configService.loadDataSourceMap();
                    if (StateNodeStatus.DISABLED.toString().equalsIgnoreCase(InstanceListenerManager.this.regCenter.get(event.getKey()))) {
                        for (String each : dataSourceMap.keySet()) {
                            dataSourceMap.put(each, (DataSource)((Object)new CircuitBreakerDataSource()));
                        }
                    }
                    try {
                        shardingDataSource.renew(InstanceListenerManager.this.configService.loadShardingRuleConfiguration().build(dataSourceMap), InstanceListenerManager.this.configService.loadShardingProperties());
                    }
                    catch (SQLException ex) {
                        throw new ShardingJdbcException((Exception)ex);
                    }
                }
            }
        });
    }

    @Override
    public void start(final MasterSlaveDataSource masterSlaveDataSource) {
        this.regCenter.watch(this.stateNode.getInstancesNodeFullPath(new OrchestrationInstance().getInstanceId()), new EventListener(){

            @Override
            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    Map<String, DataSource> dataSourceMap = InstanceListenerManager.this.configService.loadDataSourceMap();
                    if (StateNodeStatus.DISABLED.toString().equalsIgnoreCase(InstanceListenerManager.this.regCenter.get(event.getKey()))) {
                        for (String each : dataSourceMap.keySet()) {
                            dataSourceMap.put(each, (DataSource)((Object)new CircuitBreakerDataSource()));
                        }
                    }
                    masterSlaveDataSource.renew(InstanceListenerManager.this.configService.loadMasterSlaveRuleConfiguration().build(dataSourceMap));
                }
            }
        });
    }
}

