/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.state.datasource;

import io.shardingjdbc.core.exception.ShardingJdbcException;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.internal.config.ConfigurationService;
import io.shardingjdbc.orchestration.internal.listener.ListenerManager;
import io.shardingjdbc.orchestration.internal.state.StateNode;
import io.shardingjdbc.orchestration.internal.state.datasource.DataSourceService;
import io.shardingjdbc.orchestration.reg.api.RegistryCenter;
import io.shardingjdbc.orchestration.reg.listener.DataChangedEvent;
import io.shardingjdbc.orchestration.reg.listener.EventListener;
import java.sql.SQLException;

public final class DataSourceListenerManager
implements ListenerManager {
    private final StateNode stateNode;
    private final RegistryCenter regCenter;
    private final ConfigurationService configService;
    private final DataSourceService dataSourceService;

    public DataSourceListenerManager(String name, RegistryCenter regCenter) {
        this.stateNode = new StateNode(name);
        this.regCenter = regCenter;
        this.configService = new ConfigurationService(name, regCenter);
        this.dataSourceService = new DataSourceService(name, regCenter);
    }

    @Override
    public void start(final ShardingDataSource shardingDataSource) {
        this.regCenter.watch(this.stateNode.getDataSourcesNodeFullPath(), new EventListener(){

            @Override
            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType() || DataChangedEvent.Type.DELETED == event.getEventType()) {
                    try {
                        shardingDataSource.renew(DataSourceListenerManager.this.dataSourceService.getAvailableShardingRuleConfiguration().build(DataSourceListenerManager.this.dataSourceService.getAvailableDataSources()), DataSourceListenerManager.this.configService.loadShardingProperties());
                    }
                    catch (SQLException ex) {
                        throw new ShardingJdbcException((Exception)ex);
                    }
                }
            }
        });
    }

    @Override
    public void start(final MasterSlaveDataSource masterSlaveDataSource) {
        this.regCenter.watch(this.stateNode.getDataSourcesNodeFullPath(), new EventListener(){

            @Override
            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType() || DataChangedEvent.Type.DELETED == event.getEventType()) {
                    masterSlaveDataSource.renew(DataSourceListenerManager.this.dataSourceService.getAvailableMasterSlaveRuleConfiguration().build(DataSourceListenerManager.this.dataSourceService.getAvailableDataSources()));
                }
            }
        });
    }
}

