/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.listener;

import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.internal.config.ConfigMapListenerManager;
import io.shardingjdbc.orchestration.internal.config.ConfigurationListenerManager;
import io.shardingjdbc.orchestration.internal.state.datasource.DataSourceListenerManager;
import io.shardingjdbc.orchestration.internal.state.instance.InstanceListenerManager;
import io.shardingjdbc.orchestration.reg.api.RegistryCenter;

public final class ListenerFactory {
    private final ConfigurationListenerManager configurationListenerManager;
    private final InstanceListenerManager instanceListenerManager;
    private final ConfigMapListenerManager configMapListenerManager;
    private final DataSourceListenerManager dataSourceListenerManager;

    public ListenerFactory(String name, RegistryCenter regCenter) {
        this.configurationListenerManager = new ConfigurationListenerManager(name, regCenter);
        this.instanceListenerManager = new InstanceListenerManager(name, regCenter);
        this.configMapListenerManager = new ConfigMapListenerManager(name, regCenter);
        this.dataSourceListenerManager = new DataSourceListenerManager(name, regCenter);
    }

    public void initShardingListeners(ShardingDataSource shardingDataSource) {
        this.configurationListenerManager.start(shardingDataSource);
        this.instanceListenerManager.start(shardingDataSource);
        this.dataSourceListenerManager.start(shardingDataSource);
        this.configMapListenerManager.start(shardingDataSource);
    }

    public void initMasterSlaveListeners(MasterSlaveDataSource masterSlaveDataSource) {
        this.configurationListenerManager.start(masterSlaveDataSource);
        this.instanceListenerManager.start(masterSlaveDataSource);
        this.dataSourceListenerManager.start(masterSlaveDataSource);
        this.configMapListenerManager.start(masterSlaveDataSource);
    }
}

