/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.config;

import io.shardingjdbc.core.api.ConfigMapContext;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.internal.config.ConfigurationNode;
import io.shardingjdbc.orchestration.internal.config.ConfigurationService;
import io.shardingjdbc.orchestration.internal.listener.ListenerManager;
import io.shardingjdbc.orchestration.reg.api.RegistryCenter;
import io.shardingjdbc.orchestration.reg.listener.DataChangedEvent;
import io.shardingjdbc.orchestration.reg.listener.EventListener;

public final class ConfigMapListenerManager
implements ListenerManager {
    private final ConfigurationNode configNode;
    private final RegistryCenter regCenter;
    private final ConfigurationService configService;

    public ConfigMapListenerManager(String name, RegistryCenter regCenter) {
        this.configNode = new ConfigurationNode(name);
        this.regCenter = regCenter;
        this.configService = new ConfigurationService(name, regCenter);
    }

    @Override
    public void start(ShardingDataSource shardingDataSource) {
        String cachePath = this.configNode.getFullPath("config/sharding/configmap");
        this.regCenter.watch(cachePath, new EventListener(){

            @Override
            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    ConfigMapContext.getInstance().getShardingConfig().clear();
                    ConfigMapContext.getInstance().getShardingConfig().putAll(ConfigMapListenerManager.this.configService.loadShardingConfigMap());
                }
            }
        });
    }

    @Override
    public void start(MasterSlaveDataSource masterSlaveDataSource) {
        String cachePath = this.configNode.getFullPath("config/masterslave/configmap");
        this.regCenter.watch(cachePath, new EventListener(){

            @Override
            public void onChange(DataChangedEvent event) {
                if (DataChangedEvent.Type.UPDATED == event.getEventType()) {
                    ConfigMapContext.getInstance().getMasterSlaveConfig().clear();
                    ConfigMapContext.getInstance().getMasterSlaveConfig().putAll(ConfigMapListenerManager.this.configService.loadMasterSlaveConfigMap());
                }
            }
        });
    }
}

