/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal;

import com.google.common.base.Preconditions;
import io.shardingjdbc.core.api.MasterSlaveDataSourceFactory;
import io.shardingjdbc.core.api.ShardingDataSourceFactory;
import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingjdbc.core.api.config.ShardingRuleConfiguration;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.internal.config.ConfigurationService;
import io.shardingjdbc.orchestration.internal.listener.ListenerFactory;
import io.shardingjdbc.orchestration.internal.state.datasource.DataSourceService;
import io.shardingjdbc.orchestration.internal.state.instance.InstanceStateService;
import io.shardingjdbc.orchestration.reg.api.RegistryCenter;
import io.shardingjdbc.orchestration.reg.api.RegistryCenterConfiguration;
import io.shardingjdbc.orchestration.reg.etcd.EtcdConfiguration;
import io.shardingjdbc.orchestration.reg.etcd.EtcdRegistryCenter;
import io.shardingjdbc.orchestration.reg.zookeeper.ZookeeperConfiguration;
import io.shardingjdbc.orchestration.reg.zookeeper.ZookeeperRegistryCenter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public final class OrchestrationFacade {
    private final boolean isOverwrite;
    private final ConfigurationService configService;
    private final InstanceStateService instanceStateService;
    private final DataSourceService dataSourceService;
    private final ListenerFactory listenerManager;

    public OrchestrationFacade(OrchestrationConfiguration config) {
        RegistryCenter regCenter = this.createRegistryCenter(config.getRegCenterConfig());
        this.isOverwrite = config.isOverwrite();
        this.configService = new ConfigurationService(config.getName(), regCenter);
        this.instanceStateService = new InstanceStateService(config.getName(), regCenter);
        this.dataSourceService = new DataSourceService(config.getName(), regCenter);
        this.listenerManager = new ListenerFactory(config.getName(), regCenter);
    }

    private RegistryCenter createRegistryCenter(RegistryCenterConfiguration regCenterConfig) {
        Preconditions.checkNotNull((Object)regCenterConfig, (Object)"Registry center configuration cannot be null.");
        if (regCenterConfig instanceof ZookeeperConfiguration) {
            return new ZookeeperRegistryCenter((ZookeeperConfiguration)regCenterConfig);
        }
        if (regCenterConfig instanceof EtcdConfiguration) {
            return new EtcdRegistryCenter((EtcdConfiguration)regCenterConfig);
        }
        throw new UnsupportedOperationException(regCenterConfig.getClass().getName());
    }

    public ShardingDataSource getOrchestrationShardingDataSource(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig, Map<String, Object> configMap, Properties props) throws SQLException {
        if (shardingRuleConfig.getMasterSlaveRuleConfigs().isEmpty()) {
            this.reviseShardingRuleConfigurationForMasterSlave(dataSourceMap, shardingRuleConfig);
        }
        this.configService.persistShardingConfiguration(this.getActualDataSourceMapForMasterSlave(dataSourceMap), shardingRuleConfig, configMap, props, this.isOverwrite);
        this.instanceStateService.persistShardingInstanceOnline();
        this.dataSourceService.persistDataSourcesNode();
        ShardingDataSource result = (ShardingDataSource)ShardingDataSourceFactory.createDataSource(this.dataSourceService.getAvailableDataSources(), (ShardingRuleConfiguration)this.dataSourceService.getAvailableShardingRuleConfiguration(), this.configService.loadShardingConfigMap(), (Properties)this.configService.loadShardingProperties());
        this.listenerManager.initShardingListeners(result);
        return result;
    }

    private void reviseShardingRuleConfigurationForMasterSlave(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig) {
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            if (!(entry.getValue() instanceof MasterSlaveDataSource)) continue;
            MasterSlaveDataSource masterSlaveDataSource = (MasterSlaveDataSource)entry.getValue();
            shardingRuleConfig.getMasterSlaveRuleConfigs().add(this.getMasterSlaveRuleConfiguration(masterSlaveDataSource));
        }
    }

    private Map<String, DataSource> getActualDataSourceMapForMasterSlave(Map<String, DataSource> dataSourceMap) {
        HashMap<String, DataSource> result = new HashMap<String, DataSource>();
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            if (entry.getValue() instanceof MasterSlaveDataSource) {
                MasterSlaveDataSource masterSlaveDataSource = (MasterSlaveDataSource)entry.getValue();
                result.putAll(masterSlaveDataSource.getAllDataSources());
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private MasterSlaveRuleConfiguration getMasterSlaveRuleConfiguration(MasterSlaveDataSource masterSlaveDataSource) {
        MasterSlaveRuleConfiguration result = new MasterSlaveRuleConfiguration();
        result.setName(masterSlaveDataSource.getMasterSlaveRule().getName());
        result.setMasterDataSourceName(masterSlaveDataSource.getMasterSlaveRule().getMasterDataSourceName());
        result.setSlaveDataSourceNames(masterSlaveDataSource.getMasterSlaveRule().getSlaveDataSourceMap().keySet());
        result.setLoadBalanceAlgorithmClassName(masterSlaveDataSource.getMasterSlaveRule().getStrategy().getClass().getName());
        return result;
    }

    public MasterSlaveDataSource getOrchestrationMasterSlaveDataSource(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig, Map<String, Object> configMap) throws SQLException {
        this.configService.persistMasterSlaveConfiguration(dataSourceMap, masterSlaveRuleConfig, configMap, this.isOverwrite);
        this.instanceStateService.persistMasterSlaveInstanceOnline();
        this.dataSourceService.persistDataSourcesNode();
        MasterSlaveDataSource result = (MasterSlaveDataSource)MasterSlaveDataSourceFactory.createDataSource(this.dataSourceService.getAvailableDataSources(), (MasterSlaveRuleConfiguration)this.dataSourceService.getAvailableMasterSlaveRuleConfiguration(), this.configService.loadMasterSlaveConfigMap());
        this.listenerManager.initMasterSlaveListeners(result);
        return result;
    }

    public Map<String, DataSource> loadDataSourceMap(Map<String, DataSource> originalDataSourceMap) {
        if (this.isOverwrite || !this.configService.hasDataSourceConfiguration()) {
            return originalDataSourceMap;
        }
        return this.dataSourceService.getAvailableDataSources();
    }

    public ShardingRuleConfiguration loadShardingRuleConfiguration(ShardingRuleConfiguration originalShardingRuleConfig) {
        if (this.isOverwrite || !this.configService.hasShardingRuleConfiguration()) {
            return originalShardingRuleConfig;
        }
        return this.dataSourceService.getAvailableShardingRuleConfiguration();
    }

    public Map<String, Object> loadShardingConfigMap(Map<String, Object> originalShardingConfigMap) {
        if (this.isOverwrite || !this.configService.hasShardingConfigMap()) {
            return originalShardingConfigMap;
        }
        return this.configService.loadShardingConfigMap();
    }

    public Properties loadShardingProperties(Properties originalShardingProperties) {
        if (this.isOverwrite || !this.configService.hasShardingProperties()) {
            return originalShardingProperties;
        }
        return this.configService.loadShardingProperties();
    }

    public MasterSlaveRuleConfiguration loadMasterSlaveRuleConfiguration(MasterSlaveRuleConfiguration originalMasterSlaveRuleConfig) {
        if (this.isOverwrite || !this.configService.hasMasterSlaveRuleConfiguration()) {
            return originalMasterSlaveRuleConfig;
        }
        return this.dataSourceService.getAvailableMasterSlaveRuleConfiguration();
    }

    public Map<String, Object> loadMasterSlaveConfigMap(Map<String, Object> originalMasterSlaveConfigMap) {
        if (this.isOverwrite || !this.configService.hasMasterSlaveConfigMap()) {
            return originalMasterSlaveConfigMap;
        }
        return this.configService.loadMasterSlaveConfigMap();
    }
}

