/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.state.instance;

import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.internal.state.StateNode;
import io.shardingjdbc.orchestration.internal.state.instance.OrchestrationInstance;
import io.shardingjdbc.orchestration.reg.base.CoordinatorRegistryCenter;

public final class InstanceStateService {
    private final StateNode stateNode;
    private final CoordinatorRegistryCenter regCenter;

    public InstanceStateService(OrchestrationConfiguration config) {
        this.stateNode = new StateNode(config.getName());
        this.regCenter = config.getRegistryCenter();
    }

    public void persistShardingInstanceOnline() {
        String instanceNodePath = this.stateNode.getInstancesNodeFullPath(new OrchestrationInstance().getInstanceId());
        this.regCenter.persistEphemeral(instanceNodePath, "");
        this.regCenter.addCacheData(instanceNodePath);
    }

    public void persistMasterSlaveInstanceOnline() {
        String instanceNodePath = this.stateNode.getInstancesNodeFullPath(new OrchestrationInstance().getInstanceId());
        this.regCenter.persistEphemeral(instanceNodePath, "");
        this.regCenter.addCacheData(instanceNodePath);
    }
}

