/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.state.instance;

import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.internal.config.ConfigurationService;
import io.shardingjdbc.orchestration.internal.jdbc.datasource.CircuitBreakerDataSource;
import io.shardingjdbc.orchestration.internal.listener.ListenerManager;
import io.shardingjdbc.orchestration.internal.state.StateNode;
import io.shardingjdbc.orchestration.internal.state.StateNodeStatus;
import io.shardingjdbc.orchestration.internal.state.instance.OrchestrationInstance;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;

public final class InstanceListenerManager
implements ListenerManager {
    private final OrchestrationConfiguration config;
    private final StateNode stateNode;
    private final ConfigurationService configurationService;

    public InstanceListenerManager(OrchestrationConfiguration config) {
        this.config = config;
        this.stateNode = new StateNode(config.getName());
        this.configurationService = new ConfigurationService(config);
    }

    @Override
    public void start(final ShardingDataSource shardingDataSource) {
        TreeCache cache = (TreeCache)this.config.getRegistryCenter().getRawCache(this.stateNode.getInstancesNodeFullPath(new OrchestrationInstance().getInstanceId()));
        cache.getListenable().addListener((Object)new TreeCacheListener(){

            public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
                ChildData childData = event.getData();
                if (null == childData || null == childData.getData() || childData.getPath().isEmpty() || TreeCacheEvent.Type.NODE_UPDATED != event.getType()) {
                    return;
                }
                Map<String, DataSource> dataSourceMap = InstanceListenerManager.this.configurationService.loadDataSourceMap();
                if (StateNodeStatus.DISABLED.toString().equalsIgnoreCase(InstanceListenerManager.this.config.getRegistryCenter().get(childData.getPath()))) {
                    for (String each : dataSourceMap.keySet()) {
                        dataSourceMap.put(each, (DataSource)((Object)new CircuitBreakerDataSource()));
                    }
                }
                shardingDataSource.renew(InstanceListenerManager.this.configurationService.loadShardingRuleConfiguration().build(dataSourceMap), InstanceListenerManager.this.configurationService.loadShardingProperties());
            }
        });
    }

    @Override
    public void start(final MasterSlaveDataSource masterSlaveDataSource) {
        TreeCache cache = (TreeCache)this.config.getRegistryCenter().getRawCache(this.stateNode.getInstancesNodeFullPath(new OrchestrationInstance().getInstanceId()));
        cache.getListenable().addListener((Object)new TreeCacheListener(){

            public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
                ChildData childData = event.getData();
                if (null == childData || null == childData.getData() || childData.getPath().isEmpty() || TreeCacheEvent.Type.NODE_UPDATED != event.getType()) {
                    return;
                }
                Map<String, DataSource> dataSourceMap = InstanceListenerManager.this.configurationService.loadDataSourceMap();
                if (StateNodeStatus.DISABLED.toString().equalsIgnoreCase(InstanceListenerManager.this.config.getRegistryCenter().get(childData.getPath()))) {
                    for (String each : dataSourceMap.keySet()) {
                        dataSourceMap.put(each, (DataSource)((Object)new CircuitBreakerDataSource()));
                    }
                }
                masterSlaveDataSource.renew(InstanceListenerManager.this.configurationService.loadMasterSlaveRuleConfiguration().build(dataSourceMap));
            }
        });
    }
}

