/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.state.datasource;

import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingjdbc.core.api.config.ShardingRuleConfiguration;
import io.shardingjdbc.core.rule.MasterSlaveRule;
import io.shardingjdbc.core.rule.ShardingRule;
import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.internal.config.ConfigurationService;
import io.shardingjdbc.orchestration.internal.state.StateNode;
import io.shardingjdbc.orchestration.internal.state.StateNodeStatus;
import io.shardingjdbc.orchestration.reg.base.CoordinatorRegistryCenter;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public final class DataSourceService {
    private final StateNode stateNode;
    private final CoordinatorRegistryCenter regCenter;
    private final ConfigurationService configurationService;

    public DataSourceService(OrchestrationConfiguration config) {
        this.stateNode = new StateNode(config.getName());
        this.regCenter = config.getRegistryCenter();
        this.configurationService = new ConfigurationService(config);
    }

    public void persistDataSourcesNode() {
        String dataSourceNodePath = this.stateNode.getDataSourcesNodeFullPath();
        this.regCenter.persist(dataSourceNodePath, "");
        this.regCenter.addCacheData(dataSourceNodePath);
    }

    public boolean hasDisabledDataSource() {
        boolean result = false;
        String dataSourcesNodePath = this.stateNode.getDataSourcesNodeFullPath();
        List<String> dataSources = this.regCenter.getChildrenKeys(dataSourcesNodePath);
        for (String each : dataSources) {
            String path = dataSourcesNodePath + "/" + each;
            if (!StateNodeStatus.DISABLED.toString().equalsIgnoreCase(this.regCenter.get(path))) continue;
            result = true;
        }
        return result;
    }

    public ShardingRule getAvailableShardingRule() throws SQLException {
        Map<String, DataSource> dataSourceMap = this.configurationService.loadDataSourceMap();
        String dataSourcesNodePath = this.stateNode.getDataSourcesNodeFullPath();
        List<String> dataSources = this.regCenter.getChildrenKeys(dataSourcesNodePath);
        ShardingRuleConfiguration ruleConfig = this.configurationService.loadShardingRuleConfiguration();
        for (String each : dataSources) {
            String dataSourceName = each.substring(each.lastIndexOf("/") + 1);
            String path = dataSourcesNodePath + "/" + each;
            if (!StateNodeStatus.DISABLED.toString().equalsIgnoreCase(this.regCenter.get(path)) || !dataSourceMap.containsKey(dataSourceName)) continue;
            dataSourceMap.remove(dataSourceName);
            for (MasterSlaveRuleConfiguration msRuleConfig : ruleConfig.getMasterSlaveRuleConfigs()) {
                msRuleConfig.getSlaveDataSourceNames().remove(dataSourceName);
            }
        }
        return ruleConfig.build(dataSourceMap);
    }

    public MasterSlaveRule getAvailableMasterSlaveRule() {
        Map<String, DataSource> dataSourceMap = this.configurationService.loadDataSourceMap();
        String dataSourcesNodePath = this.stateNode.getDataSourcesNodeFullPath();
        List<String> dataSources = this.regCenter.getChildrenKeys(dataSourcesNodePath);
        MasterSlaveRuleConfiguration ruleConfig = this.configurationService.loadMasterSlaveRuleConfiguration();
        for (String each : dataSources) {
            String dataSourceName = each.substring(each.lastIndexOf("/") + 1);
            String path = dataSourcesNodePath + "/" + each;
            if (!StateNodeStatus.DISABLED.toString().equalsIgnoreCase(this.regCenter.get(path)) || !dataSourceMap.containsKey(dataSourceName)) continue;
            dataSourceMap.remove(dataSourceName);
            ruleConfig.getSlaveDataSourceNames().remove(dataSourceName);
        }
        return ruleConfig.build(dataSourceMap);
    }

    public StateNode getStateNode() {
        return this.stateNode;
    }

    public CoordinatorRegistryCenter getRegCenter() {
        return this.regCenter;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }
}

