/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.state.datasource;

import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.internal.config.ConfigurationService;
import io.shardingjdbc.orchestration.internal.listener.ListenerManager;
import io.shardingjdbc.orchestration.internal.state.StateNode;
import io.shardingjdbc.orchestration.internal.state.datasource.DataSourceService;
import io.shardingjdbc.orchestration.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;

public final class DataSourceListenerManager
implements ListenerManager {
    private final StateNode stateNode;
    private final CoordinatorRegistryCenter registryCenter;
    private final ConfigurationService configurationService;
    private final DataSourceService dataSourceService;

    public DataSourceListenerManager(OrchestrationConfiguration config) {
        this.stateNode = new StateNode(config.getName());
        this.registryCenter = config.getRegistryCenter();
        this.configurationService = new ConfigurationService(config);
        this.dataSourceService = new DataSourceService(config);
    }

    @Override
    public void start(final ShardingDataSource shardingDataSource) {
        TreeCache cache = (TreeCache)this.registryCenter.getRawCache(this.stateNode.getDataSourcesNodeFullPath());
        cache.getListenable().addListener((Object)new TreeCacheListener(){

            public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
                ChildData childData = event.getData();
                if (null == childData || null == childData.getData() || childData.getPath().isEmpty()) {
                    return;
                }
                if (TreeCacheEvent.Type.NODE_UPDATED == event.getType() || TreeCacheEvent.Type.NODE_REMOVED == event.getType()) {
                    shardingDataSource.renew(DataSourceListenerManager.this.dataSourceService.getAvailableShardingRule(), DataSourceListenerManager.this.configurationService.loadShardingProperties());
                }
            }
        });
    }

    @Override
    public void start(final MasterSlaveDataSource masterSlaveDataSource) {
        TreeCache cache = (TreeCache)this.registryCenter.getRawCache(this.stateNode.getDataSourcesNodeFullPath());
        cache.getListenable().addListener((Object)new TreeCacheListener(){

            public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
                ChildData childData = event.getData();
                if (null == childData || null == childData.getData() || childData.getPath().isEmpty()) {
                    return;
                }
                if (TreeCacheEvent.Type.NODE_UPDATED == event.getType() || TreeCacheEvent.Type.NODE_REMOVED == event.getType()) {
                    masterSlaveDataSource.renew(DataSourceListenerManager.this.dataSourceService.getAvailableMasterSlaveRule());
                }
            }
        });
    }
}

