/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.listener;

import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.internal.config.ConfigMapListenerManager;
import io.shardingjdbc.orchestration.internal.config.ConfigurationListenerManager;
import io.shardingjdbc.orchestration.internal.state.datasource.DataSourceListenerManager;
import io.shardingjdbc.orchestration.internal.state.instance.InstanceListenerManager;

public final class ListenerFactory {
    private final ConfigurationListenerManager configurationListenerManager;
    private final InstanceListenerManager instanceListenerManager;
    private final ConfigMapListenerManager configMapListenerManager;
    private final DataSourceListenerManager dataSourceListenerManager;

    public ListenerFactory(OrchestrationConfiguration config) {
        this.configurationListenerManager = new ConfigurationListenerManager(config);
        this.instanceListenerManager = new InstanceListenerManager(config);
        this.configMapListenerManager = new ConfigMapListenerManager(config);
        this.dataSourceListenerManager = new DataSourceListenerManager(config);
    }

    public void initShardingListeners(ShardingDataSource shardingDataSource) {
        this.configurationListenerManager.start(shardingDataSource);
        this.instanceListenerManager.start(shardingDataSource);
        this.dataSourceListenerManager.start(shardingDataSource);
        this.configMapListenerManager.start(shardingDataSource);
    }

    public void initMasterSlaveListeners(MasterSlaveDataSource masterSlaveDataSource) {
        this.configurationListenerManager.start(masterSlaveDataSource);
        this.instanceListenerManager.start(masterSlaveDataSource);
        this.dataSourceListenerManager.start(masterSlaveDataSource);
        this.configMapListenerManager.start(masterSlaveDataSource);
    }
}

