/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.json;

import com.google.common.collect.Sets;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.shardingjdbc.core.exception.ShardingJdbcException;
import io.shardingjdbc.core.jdbc.core.datasource.NamedDataSource;
import io.shardingjdbc.core.util.DataSourceUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public final class DataSourceGsonTypeAdapter
extends TypeAdapter<NamedDataSource> {
    private static Collection<Class<?>> generalClassType = Sets.newHashSet((Object[])new Class[]{Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class});

    public NamedDataSource read(JsonReader in) throws IOException {
        String name = "";
        String clazz = "";
        TreeMap<String, String> properties = new TreeMap<String, String>();
        in.beginObject();
        while (in.hasNext()) {
            String jsonName = in.nextName();
            if ("name".equals(jsonName)) {
                name = in.nextString();
                continue;
            }
            if ("clazz".equals(jsonName)) {
                clazz = in.nextString();
                continue;
            }
            properties.put(jsonName, in.nextString());
        }
        in.endObject();
        try {
            return new NamedDataSource(name, DataSourceUtil.getDataSource((String)clazz, properties));
        }
        catch (ReflectiveOperationException ex) {
            throw new ShardingJdbcException((Exception)ex);
        }
    }

    public void write(JsonWriter out, NamedDataSource value) throws IOException {
        out.beginObject();
        out.name("name").value(value.getName());
        out.name("clazz").value(value.getDataSource().getClass().getName());
        Method[] methods = value.getDataSource().getClass().getMethods();
        TreeMap<String, Method> getterMethods = new TreeMap<String, Method>();
        TreeMap<String, Method> setterMethods = new TreeMap<String, Method>();
        for (Method each : methods) {
            if (this.isGetterMethod(each)) {
                getterMethods.put(this.getPropertyName(each), each);
                continue;
            }
            if (!this.isSetterMethod(each)) continue;
            setterMethods.put(this.getPropertyName(each), each);
        }
        Map<String, Method> getterPairedGetterMethods = this.getPairedGetterMethods(getterMethods, setterMethods);
        for (Map.Entry<String, Method> entry : getterPairedGetterMethods.entrySet()) {
            Object getterResult = null;
            try {
                getterResult = entry.getValue().invoke((Object)value.getDataSource(), new Object[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (null == getterResult) continue;
            out.name(entry.getKey()).value(getterResult.toString());
        }
        out.endObject();
    }

    private boolean isGetterMethod(Method method) {
        return method.getName().startsWith("get") && 0 == method.getParameterTypes().length && this.isGeneralClassType(method.getReturnType());
    }

    private boolean isSetterMethod(Method method) {
        return method.getName().startsWith("set") && 1 == method.getParameterTypes().length && this.isGeneralClassType(method.getParameterTypes()[0]) && this.isVoid(method.getReturnType());
    }

    private boolean isGeneralClassType(Class<?> clazz) {
        return generalClassType.contains(clazz);
    }

    private boolean isVoid(Class<?> clazz) {
        return Void.TYPE == clazz || Void.class == clazz;
    }

    private String getPropertyName(Method method) {
        return String.valueOf(method.getName().charAt(3)).toLowerCase() + method.getName().substring(4, method.getName().length());
    }

    private Map<String, Method> getPairedGetterMethods(Map<String, Method> getterMethods, Map<String, Method> setterMethods) {
        TreeMap<String, Method> result = new TreeMap<String, Method>();
        for (Map.Entry<String, Method> entry : getterMethods.entrySet()) {
            if (!setterMethods.containsKey(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

