/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.config;

import com.google.common.base.Strings;
import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingjdbc.core.api.config.ShardingRuleConfiguration;
import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.internal.config.ConfigurationNode;
import io.shardingjdbc.orchestration.internal.json.DataSourceJsonConverter;
import io.shardingjdbc.orchestration.internal.json.GsonFactory;
import io.shardingjdbc.orchestration.internal.json.ShardingRuleConfigurationConverter;
import io.shardingjdbc.orchestration.reg.base.CoordinatorRegistryCenter;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public final class ConfigurationService {
    private final ConfigurationNode configNode;
    private final CoordinatorRegistryCenter regCenter;
    private final boolean isOverwrite;

    public ConfigurationService(OrchestrationConfiguration config) {
        this.configNode = new ConfigurationNode(config.getName());
        this.regCenter = config.getRegistryCenter();
        this.isOverwrite = config.isOverwrite();
    }

    public void persistShardingConfiguration(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig, Map<String, Object> configMap, Properties props) {
        this.persistDataSourceConfiguration(dataSourceMap);
        this.persistShardingRuleConfiguration(shardingRuleConfig);
        this.persistShardingConfigMap(configMap);
        this.persistShardingProperties(props);
    }

    private void persistDataSourceConfiguration(Map<String, DataSource> dataSourceMap) {
        if (this.isOverwrite || !this.regCenter.isExisted(this.configNode.getFullPath("config/datasource"))) {
            this.regCenter.persist(this.configNode.getFullPath("config/datasource"), DataSourceJsonConverter.toJson(dataSourceMap));
        }
    }

    private void persistShardingRuleConfiguration(ShardingRuleConfiguration shardingRuleConfig) {
        if (this.isOverwrite || !this.regCenter.isExisted(this.configNode.getFullPath("config/sharding/rule"))) {
            this.regCenter.persist(this.configNode.getFullPath("config/sharding/rule"), ShardingRuleConfigurationConverter.toJson(shardingRuleConfig));
        }
    }

    private void persistShardingConfigMap(Map<String, Object> configMap) {
        if (this.isOverwrite || !this.regCenter.isExisted(this.configNode.getFullPath("config/sharding/configmap"))) {
            this.regCenter.persist(this.configNode.getFullPath("config/sharding/configmap"), GsonFactory.getGson().toJson(configMap));
        }
    }

    private void persistShardingProperties(Properties props) {
        if (this.isOverwrite || !this.regCenter.isExisted(this.configNode.getFullPath("config/sharding/props"))) {
            this.regCenter.persist(this.configNode.getFullPath("config/sharding/props"), GsonFactory.getGson().toJson((Object)props));
        }
    }

    public void persistMasterSlaveConfiguration(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig, Map<String, Object> configMap) {
        this.persistDataSourceConfiguration(dataSourceMap);
        this.persistMasterSlaveRuleConfiguration(masterSlaveRuleConfig);
        this.persistMasterSlaveConfigMap(configMap);
    }

    private void persistMasterSlaveRuleConfiguration(MasterSlaveRuleConfiguration masterSlaveRuleConfig) {
        if (this.isOverwrite || !this.regCenter.isExisted(this.configNode.getFullPath("config/masterslave/rule"))) {
            this.regCenter.persist(this.configNode.getFullPath("config/masterslave/rule"), GsonFactory.getGson().toJson((Object)masterSlaveRuleConfig));
        }
    }

    private void persistMasterSlaveConfigMap(Map<String, Object> configMap) {
        if (this.isOverwrite || !this.regCenter.isExisted(this.configNode.getFullPath("config/masterslave/configmap"))) {
            this.regCenter.persist(this.configNode.getFullPath("config/masterslave/configmap"), GsonFactory.getGson().toJson(configMap));
        }
    }

    public Map<String, DataSource> loadDataSourceMap() {
        return DataSourceJsonConverter.fromJson(this.regCenter.get(this.configNode.getFullPath("config/datasource")));
    }

    public ShardingRuleConfiguration loadShardingRuleConfiguration() {
        return ShardingRuleConfigurationConverter.fromJson(this.regCenter.get(this.configNode.getFullPath("config/sharding/rule")));
    }

    public Map<String, Object> loadShardingConfigMap() {
        return (Map)GsonFactory.getGson().fromJson(this.regCenter.get(this.configNode.getFullPath("config/sharding/configmap")), Map.class);
    }

    public Properties loadShardingProperties() {
        String data = this.regCenter.get(this.configNode.getFullPath("config/sharding/props"));
        return Strings.isNullOrEmpty((String)data) ? new Properties() : (Properties)GsonFactory.getGson().fromJson(data, Properties.class);
    }

    public MasterSlaveRuleConfiguration loadMasterSlaveRuleConfiguration() {
        return (MasterSlaveRuleConfiguration)GsonFactory.getGson().fromJson(this.regCenter.get(this.configNode.getFullPath("config/masterslave/rule")), MasterSlaveRuleConfiguration.class);
    }

    public Map<String, Object> loadMasterSlaveConfigMap() {
        return (Map)GsonFactory.getGson().fromJson(this.regCenter.get(this.configNode.getFullPath("config/masterslave/configmap")), Map.class);
    }
}

