/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.config;

import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.internal.config.ConfigurationNode;
import io.shardingjdbc.orchestration.internal.config.ConfigurationService;
import io.shardingjdbc.orchestration.internal.listener.ListenerManager;
import io.shardingjdbc.orchestration.internal.state.datasource.DataSourceService;
import io.shardingjdbc.orchestration.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;

public final class ConfigurationListenerManager
implements ListenerManager {
    private final ConfigurationNode configNode;
    private final CoordinatorRegistryCenter regCenter;
    private final ConfigurationService configurationService;
    private final DataSourceService dataSourceService;

    public ConfigurationListenerManager(OrchestrationConfiguration config) {
        this.configNode = new ConfigurationNode(config.getName());
        this.regCenter = config.getRegistryCenter();
        this.configurationService = new ConfigurationService(config);
        this.dataSourceService = new DataSourceService(config);
    }

    @Override
    public void start(ShardingDataSource shardingDataSource) {
        this.start("config/datasource", shardingDataSource);
        this.start("config/sharding/rule", shardingDataSource);
        this.start("config/sharding/props", shardingDataSource);
    }

    private void start(String node, final ShardingDataSource shardingDataSource) {
        String cachePath = this.configNode.getFullPath(node);
        this.regCenter.addCacheData(cachePath);
        TreeCache cache = (TreeCache)this.regCenter.getRawCache(cachePath);
        cache.getListenable().addListener((Object)new TreeCacheListener(){

            public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
                ChildData childData = event.getData();
                if (null == childData || childData.getPath().isEmpty() || null == childData.getData() || TreeCacheEvent.Type.NODE_UPDATED != event.getType()) {
                    return;
                }
                shardingDataSource.renew(ConfigurationListenerManager.this.dataSourceService.getAvailableShardingRule(), ConfigurationListenerManager.this.configurationService.loadShardingProperties());
            }
        });
    }

    @Override
    public void start(MasterSlaveDataSource masterSlaveDataSource) {
        this.start("config/datasource", masterSlaveDataSource);
        this.start("config/masterslave/rule", masterSlaveDataSource);
    }

    private void start(String node, final MasterSlaveDataSource masterSlaveDataSource) {
        String cachePath = this.configNode.getFullPath(node);
        this.regCenter.addCacheData(cachePath);
        TreeCache cache = (TreeCache)this.regCenter.getRawCache(cachePath);
        cache.getListenable().addListener((Object)new TreeCacheListener(){

            public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
                ChildData childData = event.getData();
                if (null == childData || childData.getPath().isEmpty() || null == childData.getData() || TreeCacheEvent.Type.NODE_UPDATED != event.getType()) {
                    return;
                }
                masterSlaveDataSource.renew(ConfigurationListenerManager.this.dataSourceService.getAvailableMasterSlaveRule());
            }
        });
    }
}

