/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal.config;

import io.shardingjdbc.core.api.ConfigMapContext;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.internal.config.ConfigurationNode;
import io.shardingjdbc.orchestration.internal.config.ConfigurationService;
import io.shardingjdbc.orchestration.internal.listener.ListenerManager;
import io.shardingjdbc.orchestration.reg.base.CoordinatorRegistryCenter;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;

public final class ConfigMapListenerManager
implements ListenerManager {
    private final ConfigurationNode configNode;
    private final CoordinatorRegistryCenter regCenter;
    private final ConfigurationService configurationService;

    public ConfigMapListenerManager(OrchestrationConfiguration config) {
        this.configNode = new ConfigurationNode(config.getName());
        this.regCenter = config.getRegistryCenter();
        this.configurationService = new ConfigurationService(config);
    }

    @Override
    public void start(ShardingDataSource shardingDataSource) {
        String cachePath = this.configNode.getFullPath("config/sharding/configmap");
        this.regCenter.addCacheData(cachePath);
        TreeCache cache = (TreeCache)this.regCenter.getRawCache(cachePath);
        cache.getListenable().addListener((Object)new TreeCacheListener(){

            public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
                ChildData childData = event.getData();
                if (null == childData || childData.getPath().isEmpty() || null == childData.getData() || TreeCacheEvent.Type.NODE_UPDATED != event.getType()) {
                    return;
                }
                ConfigMapContext.getInstance().getShardingConfig().clear();
                ConfigMapContext.getInstance().getShardingConfig().putAll(ConfigMapListenerManager.this.configurationService.loadShardingConfigMap());
            }
        });
    }

    @Override
    public void start(MasterSlaveDataSource masterSlaveDataSource) {
        String cachePath = this.configNode.getFullPath("config/masterslave/configmap");
        this.regCenter.addCacheData(cachePath);
        TreeCache cache = (TreeCache)this.regCenter.getRawCache(cachePath);
        cache.getListenable().addListener((Object)new TreeCacheListener(){

            public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
                ChildData childData = event.getData();
                if (null == childData || childData.getPath().isEmpty() || null == childData.getData() || TreeCacheEvent.Type.NODE_UPDATED != event.getType()) {
                    return;
                }
                ConfigMapContext.getInstance().getMasterSlaveConfig().clear();
                ConfigMapContext.getInstance().getMasterSlaveConfig().putAll(ConfigMapListenerManager.this.configurationService.loadMasterSlaveConfigMap());
            }
        });
    }
}

