/*
 * Decompiled with CFR 0.152.
 */
package io.shardingjdbc.orchestration.internal;

import io.shardingjdbc.core.api.config.MasterSlaveRuleConfiguration;
import io.shardingjdbc.core.api.config.ShardingRuleConfiguration;
import io.shardingjdbc.core.jdbc.core.datasource.MasterSlaveDataSource;
import io.shardingjdbc.core.jdbc.core.datasource.ShardingDataSource;
import io.shardingjdbc.orchestration.api.config.OrchestrationConfiguration;
import io.shardingjdbc.orchestration.internal.config.ConfigurationService;
import io.shardingjdbc.orchestration.internal.listener.ListenerFactory;
import io.shardingjdbc.orchestration.internal.state.datasource.DataSourceService;
import io.shardingjdbc.orchestration.internal.state.instance.InstanceStateService;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

public final class OrchestrationFacade {
    private final OrchestrationConfiguration config;
    private final ConfigurationService configurationService;
    private final InstanceStateService instanceStateService;
    private final DataSourceService dataSourceService;
    private final ListenerFactory listenerManager;

    public OrchestrationFacade(OrchestrationConfiguration config) {
        this.config = config;
        this.configurationService = new ConfigurationService(config);
        this.instanceStateService = new InstanceStateService(config);
        this.dataSourceService = new DataSourceService(config);
        this.listenerManager = new ListenerFactory(config);
    }

    public void initShardingOrchestration(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig, Map<String, Object> configMap, Properties props, ShardingDataSource shardingDataSource) throws SQLException {
        this.config.getRegistryCenter().init();
        if (shardingRuleConfig.getMasterSlaveRuleConfigs().isEmpty()) {
            this.reviseShardingRuleConfigurationForMasterSlave(dataSourceMap, shardingRuleConfig);
        }
        this.configurationService.persistShardingConfiguration(this.getActualDataSourceMapForMasterSlave(dataSourceMap), shardingRuleConfig, configMap, props);
        this.instanceStateService.persistShardingInstanceOnline();
        this.dataSourceService.persistDataSourcesNode();
        this.listenerManager.initShardingListeners(shardingDataSource);
        if (this.dataSourceService.hasDisabledDataSource()) {
            shardingDataSource.renew(this.dataSourceService.getAvailableShardingRule(), props);
        }
    }

    private void reviseShardingRuleConfigurationForMasterSlave(Map<String, DataSource> dataSourceMap, ShardingRuleConfiguration shardingRuleConfig) {
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            if (!(entry.getValue() instanceof MasterSlaveDataSource)) continue;
            MasterSlaveDataSource masterSlaveDataSource = (MasterSlaveDataSource)entry.getValue();
            shardingRuleConfig.getMasterSlaveRuleConfigs().add(this.getMasterSlaveRuleConfiguration(masterSlaveDataSource));
        }
    }

    private Map<String, DataSource> getActualDataSourceMapForMasterSlave(Map<String, DataSource> dataSourceMap) {
        HashMap<String, DataSource> result = new HashMap<String, DataSource>();
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            if (entry.getValue() instanceof MasterSlaveDataSource) {
                MasterSlaveDataSource masterSlaveDataSource = (MasterSlaveDataSource)entry.getValue();
                result.putAll(masterSlaveDataSource.getAllDataSources());
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private MasterSlaveRuleConfiguration getMasterSlaveRuleConfiguration(MasterSlaveDataSource masterSlaveDataSource) {
        MasterSlaveRuleConfiguration result = new MasterSlaveRuleConfiguration();
        result.setName(masterSlaveDataSource.getMasterSlaveRule().getName());
        result.setMasterDataSourceName(masterSlaveDataSource.getMasterSlaveRule().getMasterDataSourceName());
        result.setSlaveDataSourceNames(masterSlaveDataSource.getMasterSlaveRule().getSlaveDataSourceMap().keySet());
        result.setLoadBalanceAlgorithmClassName(masterSlaveDataSource.getMasterSlaveRule().getStrategy().getClass().getName());
        return result;
    }

    public void initMasterSlaveOrchestration(Map<String, DataSource> dataSourceMap, MasterSlaveRuleConfiguration masterSlaveRuleConfig, MasterSlaveDataSource masterSlaveDataSource, Map<String, Object> configMap) {
        this.config.getRegistryCenter().init();
        this.configurationService.persistMasterSlaveConfiguration(dataSourceMap, masterSlaveRuleConfig, configMap);
        this.instanceStateService.persistMasterSlaveInstanceOnline();
        this.dataSourceService.persistDataSourcesNode();
        this.listenerManager.initMasterSlaveListeners(masterSlaveDataSource);
        if (this.dataSourceService.hasDisabledDataSource()) {
            masterSlaveDataSource.renew(this.dataSourceService.getAvailableMasterSlaveRule());
        }
    }
}

