/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.traffic.resilience.http;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.circuit.breaker.api.CircuitBreaker;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.traffic.resilience.http.StateContext;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public final class ServiceRejectionPolicy {
    public static final CharSequence RETRY_AFTER_MILLIS = CharSequences.newAsciiString((CharSequence)"retry-after-millis");
    public static final ServiceRejectionPolicy DEFAULT_REJECTION_POLICY = new Builder().build();
    private final BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> onLimitResponseBuilder;
    private final Consumer<HttpResponseMetaData> onLimitRetryAfter;
    private final boolean onLimitStopAcceptingConnections;
    private final BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> onOpenCircuitResponseBuilder;
    private final BiConsumer<HttpResponseMetaData, StateContext> onOpenCircuitRetryAfter;

    private ServiceRejectionPolicy(BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> onLimitResponseBuilder, Consumer<HttpResponseMetaData> onLimitRetryAfter, boolean onLimitStopAcceptingConnections, BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> onOpenCircuitResponseBuilder, BiConsumer<HttpResponseMetaData, StateContext> onOpenCircuitRetryAfter) {
        this.onLimitResponseBuilder = onLimitResponseBuilder;
        this.onLimitRetryAfter = onLimitRetryAfter;
        this.onLimitStopAcceptingConnections = onLimitStopAcceptingConnections;
        this.onOpenCircuitResponseBuilder = onOpenCircuitResponseBuilder;
        this.onOpenCircuitRetryAfter = onOpenCircuitRetryAfter;
    }

    BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> onLimitResponseBuilder() {
        return this.onLimitResponseBuilder;
    }

    Consumer<HttpResponseMetaData> onLimitRetryAfter() {
        return this.onLimitRetryAfter;
    }

    boolean onLimitStopAcceptingConnections() {
        return this.onLimitStopAcceptingConnections;
    }

    BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> onOpenCircuitResponseBuilder() {
        return this.onOpenCircuitResponseBuilder;
    }

    BiConsumer<HttpResponseMetaData, StateContext> onOpenCircuitRetryAfter() {
        return this.onOpenCircuitRetryAfter;
    }

    public static Consumer<HttpResponseMetaData> retryAfterHint(int seconds) {
        CharSequence secondsSeq = CharSequences.newAsciiString((CharSequence)String.valueOf(seconds));
        return resp -> resp.addHeader(HttpHeaderNames.RETRY_AFTER, secondsSeq);
    }

    public static BiConsumer<HttpResponseMetaData, StateContext> retryAfterHintOfBreaker() {
        return (resp, state) -> resp.setHeader(HttpHeaderNames.RETRY_AFTER, CharSequences.newAsciiString((CharSequence)String.valueOf(state.breaker().remainingDurationInOpenState().getSeconds())));
    }

    public static BiConsumer<HttpResponseMetaData, CircuitBreaker> retryAfterMillisHint(Duration duration) {
        CharSequence millisSeq = CharSequences.newAsciiString((CharSequence)String.valueOf(duration.toMillis()));
        return (resp, breaker) -> resp.setHeader(RETRY_AFTER_MILLIS, millisSeq);
    }

    public static BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> tooManyRequests() {
        return (__, factory) -> Single.succeeded((Object)factory.tooManyRequests());
    }

    public static BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> serviceUnavailable() {
        return (__, factory) -> Single.succeeded((Object)factory.serviceUnavailable());
    }

    public static final class Builder {
        private BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> onLimitResponseBuilder = ServiceRejectionPolicy.tooManyRequests();
        private Consumer<HttpResponseMetaData> onLimitRetryAfter = __ -> {};
        private boolean onLimitStopAcceptingConnections;
        private BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> onOpenCircuitResponseBuilder = ServiceRejectionPolicy.serviceUnavailable();
        private BiConsumer<HttpResponseMetaData, StateContext> onOpenCircuitRetryAfter = ServiceRejectionPolicy.retryAfterHintOfBreaker();

        public Builder onLimitResponseBuilder(BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> onLimitResponseBuilder) {
            this.onLimitResponseBuilder = Objects.requireNonNull(onLimitResponseBuilder);
            return this;
        }

        public Builder onLimitRetryAfter(Consumer<HttpResponseMetaData> onLimitRetryAfter) {
            this.onLimitRetryAfter = Objects.requireNonNull(onLimitRetryAfter);
            return this;
        }

        public Builder onLimitStopAcceptingConnections(boolean stopAccepting) {
            this.onLimitStopAcceptingConnections = stopAccepting;
            return this;
        }

        public Builder onOpenCircuitResponseBuilder(BiFunction<HttpRequestMetaData, StreamingHttpResponseFactory, Single<StreamingHttpResponse>> onOpenCircuitResponseBuilder) {
            this.onOpenCircuitResponseBuilder = Objects.requireNonNull(onOpenCircuitResponseBuilder);
            return this;
        }

        public Builder onOpenCircuitRetryAfter(BiConsumer<HttpResponseMetaData, StateContext> onOpenCircuitRetryAfter) {
            this.onOpenCircuitRetryAfter = Objects.requireNonNull(onOpenCircuitRetryAfter);
            return this;
        }

        public ServiceRejectionPolicy build() {
            return new ServiceRejectionPolicy(this.onLimitResponseBuilder, this.onLimitRetryAfter, this.onLimitStopAcceptingConnections, this.onOpenCircuitResponseBuilder, this.onOpenCircuitRetryAfter);
        }
    }
}

