/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.traffic.resilience.http;

import io.servicetalk.capacity.limiter.api.CapacityLimiter;
import io.servicetalk.capacity.limiter.api.Classification;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.traffic.resilience.http.NoOpTrafficResiliencyObserver;
import io.servicetalk.traffic.resilience.http.TrafficResiliencyObserver;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SafeTrafficResiliencyObserver
implements TrafficResiliencyObserver {
    private final TrafficResiliencyObserver original;
    private static final Logger LOGGER = LoggerFactory.getLogger(SafeTrafficResiliencyObserver.class);

    SafeTrafficResiliencyObserver(TrafficResiliencyObserver original) {
        this.original = Objects.requireNonNull(original);
    }

    @Override
    public void onRejectedUnmatchedPartition(StreamingHttpRequest request) {
        try {
            this.original.onRejectedUnmatchedPartition(request);
        }
        catch (Throwable t) {
            LOGGER.error("Error during onRejectedUnmatchedPartition", t);
        }
    }

    @Override
    public void onRejectedLimit(StreamingHttpRequest request, String limiter, ContextMap meta, Classification classification) {
        try {
            this.original.onRejectedLimit(request, limiter, meta, classification);
        }
        catch (Throwable t) {
            LOGGER.error("Error during onRejectedLimit", t);
        }
    }

    @Override
    public void onRejectedOpenCircuit(StreamingHttpRequest request, String breaker, ContextMap meta, Classification classification) {
        try {
            this.original.onRejectedOpenCircuit(request, breaker, meta, classification);
        }
        catch (Throwable t) {
            LOGGER.error("Error during onRejectedOpenCircuit", t);
        }
    }

    @Override
    public TrafficResiliencyObserver.TicketObserver onAllowedThrough(StreamingHttpRequest request, CapacityLimiter.LimiterState state) {
        try {
            return this.original.onAllowedThrough(request, state);
        }
        catch (Throwable t) {
            LOGGER.error("Error during onAllowedThrough", t);
            return NoOpTrafficResiliencyObserver.NO_OP_TICKET_OBSERVER;
        }
    }
}

