/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.traffic.resilience.http;

import io.servicetalk.capacity.limiter.api.RequestDroppedException;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpResponse;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ClientPeerRejectionPolicy {
    public static final Predicate<HttpResponseMetaData> DEFAULT_CAPACITY_REJECTION_PREDICATE = metaData -> metaData.status().code() == HttpResponseStatus.TOO_MANY_REQUESTS.code() || metaData.status().code() == HttpResponseStatus.BAD_GATEWAY.code() || metaData.status().code() == HttpResponseStatus.SERVICE_UNAVAILABLE.code();
    public static final ClientPeerRejectionPolicy DEFAULT_PEER_REJECTION_POLICY = new ClientPeerRejectionPolicy(DEFAULT_CAPACITY_REJECTION_PREDICATE, Type.REJECT_RETRY, __ -> Duration.ZERO);
    private final Predicate<HttpResponseMetaData> predicate;
    private final Type type;
    private final Function<HttpResponseMetaData, Duration> delayProvider;

    private ClientPeerRejectionPolicy(Predicate<HttpResponseMetaData> predicate, Type type) {
        this.predicate = predicate;
        this.type = type;
        this.delayProvider = __ -> Duration.ZERO;
    }

    ClientPeerRejectionPolicy(Predicate<HttpResponseMetaData> predicate, Type type, Function<HttpResponseMetaData, Duration> delayProvider) {
        this.predicate = predicate;
        this.type = type;
        this.delayProvider = delayProvider;
    }

    Predicate<HttpResponseMetaData> predicate() {
        return this.predicate;
    }

    Type type() {
        return this.type;
    }

    Function<HttpResponseMetaData, Duration> delayProvider() {
        return this.delayProvider;
    }

    public static ClientPeerRejectionPolicy ofPassthrough(Predicate<HttpResponseMetaData> predicate) {
        return new ClientPeerRejectionPolicy(predicate, Type.REJECT_PASSTHROUGH);
    }

    public static ClientPeerRejectionPolicy ofRejection(Predicate<HttpResponseMetaData> rejectionPredicate) {
        return new ClientPeerRejectionPolicy(rejectionPredicate, Type.REJECT);
    }

    public static ClientPeerRejectionPolicy ofRejectionWithRetries(Predicate<HttpResponseMetaData> rejectionPredicate, Function<HttpResponseMetaData, Duration> delayProvider) {
        return new ClientPeerRejectionPolicy(rejectionPredicate, Type.REJECT_RETRY, delayProvider);
    }

    static final class PassthroughRequestDroppedException
    extends RequestDroppedException {
        private static final long serialVersionUID = 5494523265208777384L;
        private final StreamingHttpResponse response;

        PassthroughRequestDroppedException(String msg, StreamingHttpResponse response) {
            super(msg);
            this.response = Objects.requireNonNull(response);
        }

        StreamingHttpResponse response() {
            return this.response;
        }
    }

    static enum Type {
        REJECT,
        REJECT_PASSTHROUGH,
        REJECT_RETRY;

    }
}

