/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.traffic.resilience.http;

import io.servicetalk.capacity.limiter.api.CapacityLimiter;
import io.servicetalk.capacity.limiter.api.Classification;
import io.servicetalk.capacity.limiter.api.RequestDroppedException;
import io.servicetalk.circuit.breaker.api.CircuitBreaker;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpServiceContext;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.api.StreamingHttpServiceFilter;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.traffic.resilience.http.AbstractTrafficResilienceHttpFilter;
import io.servicetalk.traffic.resilience.http.NoOpTrafficResiliencyObserver;
import io.servicetalk.traffic.resilience.http.SafeTrafficResiliencyObserver;
import io.servicetalk.traffic.resilience.http.ServiceRejectionPolicy;
import io.servicetalk.traffic.resilience.http.StateContext;
import io.servicetalk.traffic.resilience.http.TrackPendingRequestsHttpFilter;
import io.servicetalk.traffic.resilience.http.TrafficResiliencyObserver;
import io.servicetalk.transport.api.ServerListenContext;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class TrafficResilienceHttpServiceFilter
extends AbstractTrafficResilienceHttpFilter
implements StreamingHttpServiceFilterFactory {
    private final ServiceRejectionPolicy serviceRejectionPolicy;

    private TrafficResilienceHttpServiceFilter(Supplier<Function<HttpRequestMetaData, CapacityLimiter>> capacityPartitionsSupplier, boolean rejectNotMatched, Supplier<Function<HttpRequestMetaData, Classification>> classifier, Consumer<CapacityLimiter.Ticket> onCompletion, Consumer<CapacityLimiter.Ticket> onCancellation, BiConsumer<CapacityLimiter.Ticket, Throwable> onError, Supplier<Function<HttpRequestMetaData, CircuitBreaker>> circuitBreakerPartitionsSupplier, ServiceRejectionPolicy onServiceRejectionPolicy, TrafficResiliencyObserver observer) {
        super(capacityPartitionsSupplier, rejectNotMatched, classifier, (HttpResponseMetaData __) -> false, (HttpResponseMetaData __) -> false, onCompletion, onCancellation, onError, circuitBreakerPartitionsSupplier, observer);
        this.serviceRejectionPolicy = onServiceRejectionPolicy;
    }

    public StreamingHttpServiceFilter create(StreamingHttpService service) {
        return TrackPendingRequestsHttpFilter.BEFORE.create((StreamingHttpService)new StreamingHttpServiceFilter((StreamingHttpService)TrackPendingRequestsHttpFilter.AFTER.create(service)){
            final Function<HttpRequestMetaData, CapacityLimiter> capacityPartitions;
            final Function<HttpRequestMetaData, CircuitBreaker> circuitBreakerPartitions;
            final Function<HttpRequestMetaData, Classification> clacifier;
            final Function<HttpResponseMetaData, Duration> delayProvider;
            {
                this.capacityPartitions = TrafficResilienceHttpServiceFilter.this.newCapacityPartitions();
                this.circuitBreakerPartitions = TrafficResilienceHttpServiceFilter.this.newCircuitBreakerPartitions();
                this.clacifier = TrafficResilienceHttpServiceFilter.this.newClassifier();
                this.delayProvider = TrafficResilienceHttpServiceFilter.this.newDelayProvider();
            }

            public Single<StreamingHttpResponse> handle(HttpServiceContext ctx, StreamingHttpRequest request, StreamingHttpResponseFactory responseFactory) {
                HttpServiceContext actualContext = ctx.parent() instanceof ServerListenContext ? (ServerListenContext)ctx.parent() : ctx;
                return TrafficResilienceHttpServiceFilter.this.applyCapacityControl(this.capacityPartitions, this.circuitBreakerPartitions, this.clacifier, this.delayProvider, (ServerListenContext)actualContext, request, responseFactory, request1 -> this.delegate().handle(ctx, request1, responseFactory));
            }
        });
    }

    @Override
    CapacityLimiter.Ticket wrapTicket(@Nullable ServerListenContext serverListenContext, CapacityLimiter.Ticket ticket) {
        return serverListenContext == null ? ticket : new ServerResumptionTicketWrapper(serverListenContext, ticket);
    }

    @Override
    Single<StreamingHttpResponse> handleLocalCapacityRejection(@Nullable ServerListenContext serverListenContext, StreamingHttpRequest request, @Nullable StreamingHttpResponseFactory responseFactory) {
        assert (serverListenContext != null);
        if (this.serviceRejectionPolicy.onLimitStopAcceptingConnections()) {
            serverListenContext.acceptConnections(false);
        }
        if (responseFactory != null) {
            return this.serviceRejectionPolicy.onLimitResponseBuilder().apply((HttpRequestMetaData)request, responseFactory).map(resp -> {
                this.serviceRejectionPolicy.onLimitRetryAfter().accept((HttpResponseMetaData)resp);
                return resp;
            });
        }
        return DEFAULT_CAPACITY_REJECTION;
    }

    @Override
    Single<StreamingHttpResponse> handleLocalBreakerRejection(StreamingHttpRequest request, @Nullable StreamingHttpResponseFactory responseFactory, CircuitBreaker breaker) {
        if (responseFactory != null) {
            return this.serviceRejectionPolicy.onOpenCircuitResponseBuilder().apply((HttpRequestMetaData)request, responseFactory).map(resp -> {
                this.serviceRejectionPolicy.onOpenCircuitRetryAfter().accept((HttpResponseMetaData)resp, new StateContext(breaker));
                return resp;
            }).shareContextOnSubscribe();
        }
        return DEFAULT_BREAKER_REJECTION;
    }

    private static final class ServerResumptionTicketWrapper
    implements CapacityLimiter.Ticket {
        private final CapacityLimiter.Ticket ticket;
        private final ServerListenContext listenContext;

        private ServerResumptionTicketWrapper(ServerListenContext listenContext, CapacityLimiter.Ticket ticket) {
            this.ticket = ticket;
            this.listenContext = listenContext;
        }

        public CapacityLimiter.LimiterState state() {
            return this.ticket.state();
        }

        public int completed() {
            int result = this.ticket.completed();
            if (result == -1 || result > 0) {
                this.listenContext.acceptConnections(true);
            }
            return result;
        }

        public int dropped() {
            int result = this.ticket.dropped();
            if (result == -1 || result > 0) {
                this.listenContext.acceptConnections(true);
            }
            return result;
        }

        public int failed(Throwable error) {
            int result = this.ticket.failed(error);
            if (result == -1 || result > 0) {
                this.listenContext.acceptConnections(true);
            }
            return result;
        }

        public int ignored() {
            int result = this.ticket.ignored();
            if (result == -1 || result > 0) {
                this.listenContext.acceptConnections(true);
            }
            return result;
        }
    }

    public static final class Builder {
        private boolean rejectNotMatched;
        private Supplier<Function<HttpRequestMetaData, CapacityLimiter>> capacityPartitionsSupplier;
        private Supplier<Function<HttpRequestMetaData, Classification>> classifier = () -> __ -> () -> Integer.MAX_VALUE;
        private Supplier<Function<HttpRequestMetaData, CircuitBreaker>> circuitBreakerPartitionsSupplier = () -> __ -> null;
        private ServiceRejectionPolicy onServiceRejectionPolicy = ServiceRejectionPolicy.DEFAULT_REJECTION_POLICY;
        private final Consumer<CapacityLimiter.Ticket> onCompletionTicketTerminal = CapacityLimiter.Ticket::completed;
        private Consumer<CapacityLimiter.Ticket> onCancellationTicketTerminal = CapacityLimiter.Ticket::ignored;
        private BiConsumer<CapacityLimiter.Ticket, Throwable> onErrorTicketTerminal = (ticket, throwable) -> {
            if (throwable instanceof RequestDroppedException || throwable instanceof TimeoutException) {
                ticket.dropped();
            } else {
                ticket.failed(throwable);
            }
        };
        private TrafficResiliencyObserver observer = NoOpTrafficResiliencyObserver.INSTANCE;

        public Builder(Supplier<CapacityLimiter> capacityLimiterSupplier) {
            Objects.requireNonNull(capacityLimiterSupplier, "capacityLimiterSupplier");
            this.capacityPartitionsSupplier = () -> {
                CapacityLimiter capacityLimiter = (CapacityLimiter)capacityLimiterSupplier.get();
                return __ -> capacityLimiter;
            };
            this.rejectNotMatched = true;
        }

        public Builder(Supplier<Function<HttpRequestMetaData, CapacityLimiter>> capacityPartitionsSupplier, boolean rejectNotMatched) {
            this.capacityPartitionsSupplier = Objects.requireNonNull(capacityPartitionsSupplier, "capacityPartitionsSupplier");
            this.rejectNotMatched = rejectNotMatched;
        }

        public Builder capacityPartitions(Supplier<Function<HttpRequestMetaData, CapacityLimiter>> capacityPartitionsSupplier, boolean rejectNotMatched) {
            this.capacityPartitionsSupplier = Objects.requireNonNull(capacityPartitionsSupplier, "capacityPartitionsSupplier");
            this.rejectNotMatched = rejectNotMatched;
            return this;
        }

        public Builder classifier(Supplier<Function<HttpRequestMetaData, Classification>> classifier) {
            this.classifier = Objects.requireNonNull(classifier, "classifier");
            return this;
        }

        public Builder circuitBreakerPartitions(Supplier<Function<HttpRequestMetaData, CircuitBreaker>> circuitBreakerPartitionsSupplier) {
            this.circuitBreakerPartitionsSupplier = Objects.requireNonNull(circuitBreakerPartitionsSupplier, "circuitBreakerPartitionsSupplier");
            return this;
        }

        public Builder onErrorTicketTerminal(BiConsumer<CapacityLimiter.Ticket, Throwable> onError) {
            this.onErrorTicketTerminal = Objects.requireNonNull(onError, "onError");
            return this;
        }

        public Builder onCancelTicketTerminal(Consumer<CapacityLimiter.Ticket> onCancellation) {
            this.onCancellationTicketTerminal = Objects.requireNonNull(onCancellation, "onCancellation");
            return this;
        }

        public Builder rejectionPolicy(ServiceRejectionPolicy policy) {
            this.onServiceRejectionPolicy = Objects.requireNonNull(policy, "policy");
            return this;
        }

        public Builder observer(TrafficResiliencyObserver observer) {
            this.observer = new SafeTrafficResiliencyObserver(observer);
            return this;
        }

        public TrafficResilienceHttpServiceFilter build() {
            return new TrafficResilienceHttpServiceFilter(this.capacityPartitionsSupplier, this.rejectNotMatched, this.classifier, this.onCompletionTicketTerminal, this.onCancellationTicketTerminal, this.onErrorTicketTerminal, this.circuitBreakerPartitionsSupplier, this.onServiceRejectionPolicy, this.observer);
        }
    }
}

