/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.log4j2;

import io.servicetalk.log4j2.mdc.utils.ServiceTalkThreadContextMap;
import io.servicetalk.opentracing.asynccontext.AsyncContextInMemoryScopeManager;
import io.servicetalk.opentracing.inmemory.api.InMemorySpan;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.logging.log4j.core.impl.JdkMapAdapterStringMap;
import org.apache.logging.log4j.util.StringMap;

public final class ServiceTalkTracingThreadContextMap
extends ServiceTalkThreadContextMap {
    private static final String TRACE_ID_KEY = "traceId";
    private static final String SPAN_ID_KEY = "spanId";
    private static final String PARENT_SPAN_ID_KEY = "parentSpanId";

    @Nullable
    public String get(String key) {
        switch (key) {
            case "traceId": {
                InMemorySpan span = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.activeSpan();
                if (span == null) break;
                return span.traceIdHex();
            }
            case "spanId": {
                InMemorySpan span = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.activeSpan();
                if (span == null) break;
                return span.spanIdHex();
            }
            case "parentSpanId": {
                InMemorySpan span = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.activeSpan();
                if (span == null) break;
                return span.nonnullParentSpanIdHex();
            }
        }
        return super.get(key);
    }

    public boolean containsKey(String key) {
        return ServiceTalkTracingThreadContextMap.containsTracingKey(key) || super.containsKey(key);
    }

    public Map<String, String> getCopy() {
        Map copy = super.getCopy();
        InMemorySpan span = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.activeSpan();
        if (span != null) {
            copy.put(TRACE_ID_KEY, span.traceIdHex());
            copy.put(SPAN_ID_KEY, span.spanIdHex());
            copy.put(PARENT_SPAN_ID_KEY, span.nonnullParentSpanIdHex());
        }
        return copy;
    }

    @Nullable
    public Map<String, String> getImmutableMapOrNull() {
        Map<String, String> copy = this.getCopyOrNull();
        return copy == null ? null : Collections.unmodifiableMap(copy);
    }

    public boolean isEmpty() {
        return super.isEmpty() && AsyncContextInMemoryScopeManager.SCOPE_MANAGER.activeSpan() == null;
    }

    public StringMap getReadOnlyContextData() {
        JdkMapAdapterStringMap map = new JdkMapAdapterStringMap(this.getCopy());
        map.freeze();
        return map;
    }

    @Nullable
    protected Map<String, String> getCopyOrNull() {
        InMemorySpan span = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.activeSpan();
        HashMap<String, String> copy = super.getCopyOrNull();
        if (copy == null && span == null) {
            return null;
        }
        if (copy == null) {
            copy = new HashMap<String, String>(4);
        }
        if (span != null) {
            copy.put(TRACE_ID_KEY, span.traceIdHex());
            copy.put(SPAN_ID_KEY, span.spanIdHex());
            copy.put(PARENT_SPAN_ID_KEY, span.nonnullParentSpanIdHex());
        }
        return copy;
    }

    private static boolean containsTracingKey(String key) {
        return (TRACE_ID_KEY.equals(key) || SPAN_ID_KEY.equals(key) || PARENT_SPAN_ID_KEY.equals(key)) && AsyncContextInMemoryScopeManager.SCOPE_MANAGER.activeSpan() != null;
    }
}

