/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.log4j2;

import io.servicetalk.log4j2.mdc.utils.ServiceTalkThreadContextMap;
import io.servicetalk.opentracing.asynccontext.AsyncContextInMemoryScopeManager;
import io.servicetalk.opentracing.inmemory.api.InMemoryScope;
import io.servicetalk.opentracing.inmemory.api.InMemorySpan;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.TriConsumer;

public final class ServiceTalkTracingThreadContextMap
extends ServiceTalkThreadContextMap {
    private static final String TRACE_ID_KEY = "traceId";
    private static final String SPAN_ID_KEY = "spanId";
    private static final String PARENT_SPAN_ID_KEY = "parentSpanId";

    @Nullable
    public String get(String key) {
        switch (key) {
            case "traceId": {
                InMemoryScope scope = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active();
                if (scope == null) break;
                return scope.span().traceIdHex();
            }
            case "spanId": {
                InMemoryScope scope = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active();
                if (scope == null) break;
                return scope.span().spanIdHex();
            }
            case "parentSpanId": {
                InMemoryScope scope = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active();
                if (scope == null) break;
                return scope.span().nonnullParentSpanIdHex();
            }
        }
        return super.get(key);
    }

    public boolean containsKey(String key) {
        return ServiceTalkTracingThreadContextMap.containsTracingKey(key) || super.containsKey(key);
    }

    private static boolean containsTracingKey(String key) {
        if (TRACE_ID_KEY.equals(key) || SPAN_ID_KEY.equals(key) || PARENT_SPAN_ID_KEY.equals(key)) {
            InMemoryScope scope = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active();
            return scope != null;
        }
        return false;
    }

    protected Map<String, String> getCopy(Map<String, String> storage) {
        return this.getCopy(storage, AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active());
    }

    private Map<String, String> getCopy(Map<String, String> storage, @Nullable InMemoryScope scope) {
        if (scope != null) {
            InMemorySpan span = scope.span();
            storage.put(TRACE_ID_KEY, span.traceIdHex());
            storage.put(SPAN_ID_KEY, span.spanIdHex());
            storage.put(PARENT_SPAN_ID_KEY, span.nonnullParentSpanIdHex());
        }
        return super.getCopy(storage);
    }

    @Nullable
    protected Map<String, String> getImmutableMapOrNull(Map<String, String> storage) {
        InMemoryScope scope = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active();
        if (storage.isEmpty() && scope == null) {
            return null;
        }
        Map<String, String> copy = this.getCopy(storage, scope);
        return copy.isEmpty() ? null : Collections.unmodifiableMap(copy);
    }

    public boolean isEmpty() {
        return super.isEmpty() && AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active() == null;
    }

    protected StringMap getReadOnlyContextData(final Map<String, String> storage) {
        return new StringMap(){
            private static final long serialVersionUID = 6255838338202729246L;

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public void freeze() {
            }

            public boolean isFrozen() {
                return true;
            }

            public void putAll(ReadOnlyStringMap source) {
                throw new UnsupportedOperationException();
            }

            public void putValue(String key, Object value) {
                throw new UnsupportedOperationException();
            }

            public void remove(String key) {
                throw new UnsupportedOperationException();
            }

            public Map<String, String> toMap() {
                return ServiceTalkTracingThreadContextMap.this.getCopy(storage, AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active());
            }

            public boolean containsKey(String key) {
                return ServiceTalkTracingThreadContextMap.containsTracingKey(key) || storage.containsKey(key);
            }

            public <V> void forEach(BiConsumer<String, ? super V> action) {
                InMemoryScope scope = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active();
                if (scope != null) {
                    InMemorySpan span = scope.span();
                    action.accept((Object)ServiceTalkTracingThreadContextMap.TRACE_ID_KEY, (Object)span.traceIdHex());
                    action.accept((Object)ServiceTalkTracingThreadContextMap.SPAN_ID_KEY, (Object)span.spanIdHex());
                    action.accept((Object)ServiceTalkTracingThreadContextMap.PARENT_SPAN_ID_KEY, (Object)span.nonnullParentSpanIdHex());
                }
                storage.forEach((? super K key, ? super V value) -> action.accept(key, value));
            }

            public <V, S> void forEach(TriConsumer<String, ? super V, S> action, S state) {
                InMemoryScope scope = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active();
                if (scope != null) {
                    InMemorySpan span = scope.span();
                    action.accept((Object)ServiceTalkTracingThreadContextMap.TRACE_ID_KEY, (Object)span.traceIdHex(), state);
                    action.accept((Object)ServiceTalkTracingThreadContextMap.SPAN_ID_KEY, (Object)span.spanIdHex(), state);
                    action.accept((Object)ServiceTalkTracingThreadContextMap.PARENT_SPAN_ID_KEY, (Object)span.nonnullParentSpanIdHex(), state);
                }
                storage.forEach((? super K key, ? super V value) -> action.accept(key, value, state));
            }

            public <V> V getValue(String key) {
                switch (key) {
                    case "traceId": {
                        InMemoryScope scope = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active();
                        if (scope == null) break;
                        return (V)scope.span().traceIdHex();
                    }
                    case "spanId": {
                        InMemoryScope scope = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active();
                        if (scope == null) break;
                        return (V)scope.span().spanIdHex();
                    }
                    case "parentSpanId": {
                        InMemoryScope scope = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active();
                        if (scope == null) break;
                        return (V)scope.span().nonnullParentSpanIdHex();
                    }
                }
                return storage.get(key);
            }

            public boolean isEmpty() {
                return storage.isEmpty() && AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active() == null;
            }

            public int size() {
                InMemoryScope scope = AsyncContextInMemoryScopeManager.SCOPE_MANAGER.active();
                return scope != null ? storage.size() + 3 : storage.size();
            }
        };
    }
}

