/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.opentracing.internal;

public final class HexUtils {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HexUtils() {
    }

    public static <T extends CharSequence> T validateHexBytes(T str) {
        if (str.length() < 16) {
            throw new IllegalArgumentException("Input has wrong length, must be at least 16 chars, got " + str.length());
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F') continue;
            throw new IllegalArgumentException("Invalid hex character '" + ch + '\'');
        }
        return str;
    }

    public static long longOfHexBytes(String str, int offset) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (offset > str.length() - 16) {
            throw new StringIndexOutOfBoundsException(offset + 16);
        }
        return (long)HexUtils.fromHexChar(str.charAt(offset)) << 60 | (long)HexUtils.fromHexChar(str.charAt(offset + 1)) << 56 | (long)HexUtils.fromHexChar(str.charAt(offset + 2)) << 52 | (long)HexUtils.fromHexChar(str.charAt(offset + 3)) << 48 | (long)HexUtils.fromHexChar(str.charAt(offset + 4)) << 44 | (long)HexUtils.fromHexChar(str.charAt(offset + 5)) << 40 | (long)HexUtils.fromHexChar(str.charAt(offset + 6)) << 36 | (long)HexUtils.fromHexChar(str.charAt(offset + 7)) << 32 | (long)HexUtils.fromHexChar(str.charAt(offset + 8)) << 28 | (long)HexUtils.fromHexChar(str.charAt(offset + 9)) << 24 | (long)HexUtils.fromHexChar(str.charAt(offset + 10)) << 20 | (long)HexUtils.fromHexChar(str.charAt(offset + 11)) << 16 | (long)HexUtils.fromHexChar(str.charAt(offset + 12)) << 12 | (long)HexUtils.fromHexChar(str.charAt(offset + 13)) << 8 | (long)HexUtils.fromHexChar(str.charAt(offset + 14)) << 4 | (long)HexUtils.fromHexChar(str.charAt(offset + 15));
    }

    public static String hexBytesOfLong(long v) {
        return String.valueOf(new char[]{HEX_CHARS[(int)(v >>> 60 & 0xFL)], HEX_CHARS[(int)(v >>> 56 & 0xFL)], HEX_CHARS[(int)(v >>> 52 & 0xFL)], HEX_CHARS[(int)(v >>> 48 & 0xFL)], HEX_CHARS[(int)(v >>> 44 & 0xFL)], HEX_CHARS[(int)(v >>> 40 & 0xFL)], HEX_CHARS[(int)(v >>> 36 & 0xFL)], HEX_CHARS[(int)(v >>> 32 & 0xFL)], HEX_CHARS[(int)(v >>> 28 & 0xFL)], HEX_CHARS[(int)(v >>> 24 & 0xFL)], HEX_CHARS[(int)(v >>> 20 & 0xFL)], HEX_CHARS[(int)(v >>> 16 & 0xFL)], HEX_CHARS[(int)(v >>> 12 & 0xFL)], HEX_CHARS[(int)(v >>> 8 & 0xFL)], HEX_CHARS[(int)(v >>> 4 & 0xFL)], HEX_CHARS[(int)(v & 0xFL)]});
    }

    private static byte fromHexChar(char c) throws IllegalArgumentException {
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48);
        }
        if (c >= 'a' && c <= 'f') {
            return (byte)(10 + c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return (byte)(10 + c - 65);
        }
        throw new IllegalArgumentException("Invalid hex char: '" + c + "'");
    }
}

