/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.log4j2.mdc.utils;

import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.context.api.ContextMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.apache.logging.log4j.spi.CleanableThreadContextMap;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.apache.logging.log4j.util.TriConsumer;

public class ServiceTalkThreadContextMap
implements ReadOnlyThreadContextMap,
CleanableThreadContextMap {
    private static final ContextMap.Key<Map<String, String>> key = ContextMap.Key.newKey((String)"log4j2Mdc", Map.class);
    private static final String NULL_STRING = "";
    private static final String[] KNOWN_CONFLICTS = new String[]{"io.servicetalk.log4j2.mdc.DefaultServiceTalkThreadContextMap", "io.servicetalk.opentracing.log4j2.ServiceTalkTracingThreadContextMap"};
    private static final String ADAPTER_CONFLICT_MESSAGE = "Detected multiple ServiceTalk MDC adapters in classpath. The %s MDC adapters should not be loaded at the same time. Please exclude one from your dependencies.%n";
    private static final String ENABLE_PROPERTY_NAME = "io.servicetalk.log4j2.mdc.utils.useCapturedContextStorage";
    private static final boolean DEFAULT_PROPERTY_VALUE = true;
    static final ThreadLocal<ConcurrentMap<String, String>> CONTEXT_STORAGE = ThreadLocal.withInitial(() -> new ConcurrentHashMap(4));
    private final boolean useLocalStorage;

    public ServiceTalkThreadContextMap() {
        this(ServiceTalkThreadContextMap.initUseLocalStorage());
    }

    public ServiceTalkThreadContextMap(boolean useLocalStorage) {
        this.detectPossibleConflicts();
        this.useLocalStorage = useLocalStorage;
    }

    private void detectPossibleConflicts() {
        ArrayList<String> found = new ArrayList<String>(KNOWN_CONFLICTS.length);
        for (String cls : KNOWN_CONFLICTS) {
            try {
                Class.forName(cls);
                found.add(cls);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (found.size() > 1) {
            System.err.printf(ADAPTER_CONFLICT_MESSAGE, Arrays.toString(found.toArray()));
            if (!System.getProperty("log4j2.threadContextMap", NULL_STRING).equals(this.getClass().getCanonicalName())) {
                throw new IllegalStateException("log4j2.threadContextMap is not set to " + this.getClass().getCanonicalName() + ". There is no way to determine which ThreadContextMap has precedence for MDC storage and behavior is therefore undefined.");
            }
        }
    }

    public final void put(String key, String value) {
        this.getStorage().put(key, ServiceTalkThreadContextMap.wrapNull(value));
    }

    @Nullable
    public String get(String key) {
        return ServiceTalkThreadContextMap.unwrapNull(this.getStorage().get(key));
    }

    public final void remove(String key) {
        this.getStorage().remove(key);
    }

    public final void clear() {
        this.getStorage().clear();
    }

    public boolean containsKey(String key) {
        return this.getStorage().containsKey(key);
    }

    public Map<String, String> getCopy() {
        return ServiceTalkThreadContextMap.getCopy(this.getStorage());
    }

    @Nullable
    public Map<String, String> getImmutableMapOrNull() {
        Map<String, String> storage = this.getStorage();
        if (storage.isEmpty()) {
            return null;
        }
        Map<String, String> copy = ServiceTalkThreadContextMap.getCopyOrNull(storage, true);
        return copy == null ? null : Collections.unmodifiableMap(copy);
    }

    public boolean isEmpty() {
        return this.getStorage().isEmpty();
    }

    public final void removeAll(Iterable<String> keys) {
        Map<String, String> storage = this.getStorage();
        keys.forEach(storage::remove);
    }

    public final void putAll(Map<String, String> map) {
        Map<String, String> storage = this.getStorage();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            storage.put(entry.getKey(), ServiceTalkThreadContextMap.wrapNull(entry.getValue()));
        }
    }

    public StringMap getReadOnlyContextData() {
        final Map<String, String> storage = this.getStorage();
        return new StringMap(){
            private static final long serialVersionUID = -1707426073379541244L;

            public void clear() {
                throw new UnsupportedOperationException();
            }

            public void freeze() {
            }

            public boolean isFrozen() {
                return true;
            }

            public void putAll(ReadOnlyStringMap source) {
                throw new UnsupportedOperationException();
            }

            public void putValue(String key, Object value) {
                throw new UnsupportedOperationException();
            }

            public void remove(String key) {
                throw new UnsupportedOperationException();
            }

            public Map<String, String> toMap() {
                return ServiceTalkThreadContextMap.getCopy(storage);
            }

            public boolean containsKey(String key) {
                return storage.containsKey(key);
            }

            public <V> void forEach(BiConsumer<String, ? super V> action) {
                storage.forEach((? super K key, ? super V value) -> action.accept(key, (Object)ServiceTalkThreadContextMap.unwrapNull(value)));
            }

            public <V, S> void forEach(TriConsumer<String, ? super V, S> action, S state) {
                storage.forEach((? super K key, ? super V value) -> action.accept(key, (Object)ServiceTalkThreadContextMap.unwrapNull(value), state));
            }

            @Nullable
            public <V> V getValue(String key) {
                return (V)ServiceTalkThreadContextMap.unwrapNull((String)storage.get(key));
            }

            public boolean isEmpty() {
                return storage.isEmpty();
            }

            public int size() {
                return storage.size();
            }
        };
    }

    @Nullable
    protected Map<String, String> getCopyOrNull() {
        return ServiceTalkThreadContextMap.getCopyOrNull(this.getStorage(), true);
    }

    boolean useLocalStorage() {
        return this.useLocalStorage;
    }

    final Map<String, String> getStorage() {
        if (this.useLocalStorage()) {
            return CONTEXT_STORAGE.get();
        }
        ContextMap context = AsyncContext.context();
        ConcurrentHashMap ret = (ConcurrentHashMap)context.get(key);
        if (ret == null) {
            ret = new ConcurrentHashMap(4);
            AsyncContext.put(key, ret);
        }
        return ret;
    }

    @Nullable
    private static Map<String, String> getCopyOrNull(Map<String, String> storage, boolean emptyReturnNull) {
        int size = storage.size();
        if (size == 0) {
            return emptyReturnNull ? null : new HashMap(2);
        }
        HashMap<String, String> copy = new HashMap<String, String>(size + (int)((float)size * 0.25f + 1.0f), 0.75f);
        for (Map.Entry<String, String> entry : storage.entrySet()) {
            copy.put(entry.getKey(), ServiceTalkThreadContextMap.unwrapNull(entry.getValue()));
        }
        return copy;
    }

    private static Map<String, String> getCopy(Map<String, String> storage) {
        Map<String, String> copy = ServiceTalkThreadContextMap.getCopyOrNull(storage, false);
        assert (copy != null);
        return copy;
    }

    private static String wrapNull(@Nullable String value) {
        return value == null ? NULL_STRING : value;
    }

    @Nullable
    private static String unwrapNull(String value) {
        return value == NULL_STRING ? null : value;
    }

    private static boolean initUseLocalStorage() {
        String propertyValue = System.getProperty(ENABLE_PROPERTY_NAME);
        return propertyValue == null ? true : Boolean.parseBoolean(propertyValue);
    }
}

