/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.log4j2.mdc.utils;

import io.servicetalk.concurrent.api.CapturedContext;
import io.servicetalk.concurrent.api.CapturedContextProvider;
import io.servicetalk.concurrent.api.Scope;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.log4j2.mdc.utils.ServiceTalkThreadContextMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.spi.ReadOnlyThreadContextMap;

public abstract class MdcCapturedContextProvider
implements CapturedContextProvider {
    private final boolean enabled;

    protected MdcCapturedContextProvider(Class<? extends ServiceTalkThreadContextMap> expectedThreadContextMapClass) {
        this.enabled = MdcCapturedContextProvider.shouldEnableMdcCapture(expectedThreadContextMapClass);
    }

    public final CapturedContext captureContext(CapturedContext underlying) {
        return this.enabled ? new MdcCapturedContext(underlying, MdcCapturedContextProvider.getCurrent()) : underlying;
    }

    public final CapturedContext captureContextCopy(CapturedContext underlying) {
        return this.enabled ? new MdcCapturedContext(underlying, MdcCapturedContextProvider.getCurrentCopy()) : underlying;
    }

    private static ConcurrentMap<String, String> getCurrent() {
        return ServiceTalkThreadContextMap.CONTEXT_STORAGE.get();
    }

    private static ConcurrentMap<String, String> getCurrentCopy() {
        ConcurrentMap<String, String> current = MdcCapturedContextProvider.getCurrent();
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>(Math.max((int)((double)current.size() * 1.5), 4));
        result.putAll(current);
        return result;
    }

    private static void setCurrent(ConcurrentMap<String, String> storage) {
        ServiceTalkThreadContextMap.CONTEXT_STORAGE.set(storage);
    }

    private static boolean shouldEnableMdcCapture(Class<? extends ServiceTalkThreadContextMap> expectedThreadContextMapClass) {
        ReadOnlyThreadContextMap implementation = ThreadContext.getThreadContextMap();
        if (expectedThreadContextMapClass == implementation.getClass()) {
            return expectedThreadContextMapClass.cast(implementation).useLocalStorage();
        }
        System.err.println("Incompatible MDC ThreadContext adapter detected:" + implementation.getClass().getName() + " (expected " + expectedThreadContextMapClass.getName() + "). ServiceTalk MDC propagation will be disabled.");
        return false;
    }

    private static final class MdcCapturedContext
    implements CapturedContext {
        private final CapturedContext delegate;
        private final ConcurrentMap<String, String> storage;

        MdcCapturedContext(CapturedContext delegate, ConcurrentMap<String, String> storage) {
            this.delegate = delegate;
            this.storage = storage;
        }

        public ContextMap captured() {
            return this.delegate.captured();
        }

        public Scope attachContext() {
            ConcurrentMap old = MdcCapturedContextProvider.getCurrent();
            MdcCapturedContextProvider.setCurrent(this.storage);
            Scope delegateScope = this.delegate.attachContext();
            return () -> {
                delegateScope.close();
                MdcCapturedContextProvider.setCurrent(old);
            };
        }
    }
}

