/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.log4j2.mdc.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggerStringWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerStringWriter.class);
    private ConcurrentStringWriter writer;

    public void reset() {
        this.getStringWriter().reset();
    }

    public void remove() {
        this.removeStringWriter();
    }

    public String accumulated() {
        return this.getStringWriter().toString();
    }

    public String stableAccumulated(int totalWaitTimeMillis) throws InterruptedException, TimeoutException {
        return this.stableAccumulated(totalWaitTimeMillis, 10L);
    }

    public String stableAccumulated(int totalWaitTimeMillis, long sleepDurationMs) throws InterruptedException, TimeoutException {
        long nanoTimeB;
        String logContent;
        String forcedLogEntry = "forced log entry to help for flush on current thread " + ThreadLocalRandom.current().nextLong();
        LOGGER.error(forcedLogEntry);
        String newLogContent = logContent = this.accumulated();
        long nanoTimeA = System.nanoTime();
        while (!logContent.contains(forcedLogEntry)) {
            if (totalWaitTimeMillis <= 0) {
                throw new TimeoutException("timed out waiting for thread: " + Thread.currentThread());
            }
            Thread.sleep(sleepDurationMs);
            nanoTimeB = System.nanoTime();
            totalWaitTimeMillis = (int)((long)totalWaitTimeMillis - TimeUnit.NANOSECONDS.toMillis(nanoTimeB - nanoTimeA));
            nanoTimeA = nanoTimeB;
            logContent = newLogContent = this.accumulated();
        }
        do {
            logContent = newLogContent;
            if (totalWaitTimeMillis <= 0) {
                throw new TimeoutException("timed out waiting for thread: " + Thread.currentThread());
            }
            Thread.sleep(sleepDurationMs);
            nanoTimeB = System.nanoTime();
            totalWaitTimeMillis = (int)((long)totalWaitTimeMillis - TimeUnit.NANOSECONDS.toMillis(nanoTimeB - nanoTimeA));
            nanoTimeA = nanoTimeB;
        } while (!(newLogContent = this.accumulated()).equals(logContent));
        return logContent;
    }

    public static void assertContainsMdcPair(String value, String expectedLabel, String expectedValue) {
        int x = value.indexOf(expectedLabel);
        MatcherAssert.assertThat((String)("couldn't find expectedLabel: " + expectedLabel), (Object)x, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))));
        int beginIndex = x + expectedLabel.length();
        MatcherAssert.assertThat((Object)value.substring(beginIndex, beginIndex + expectedValue.length()), (Matcher)CoreMatchers.is((Object)expectedValue));
    }

    private synchronized ConcurrentStringWriter getStringWriter() {
        if (this.writer == null) {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            this.writer = LoggerStringWriter.addWriterAppender(context, Level.DEBUG);
        }
        return this.writer;
    }

    private synchronized void removeStringWriter() {
        if (this.writer == null) {
            return;
        }
        LoggerStringWriter.removeWriterAppender(this.writer, (LoggerContext)LogManager.getContext((boolean)false));
        this.writer = null;
    }

    private static ConcurrentStringWriter addWriterAppender(LoggerContext context, Level level) {
        Configuration config = context.getConfiguration();
        ConcurrentStringWriter writer = new ConcurrentStringWriter();
        Map.Entry existing = config.getAppenders().entrySet().iterator().next();
        WriterAppender writerAppender = ((WriterAppender.Builder)((WriterAppender.Builder)WriterAppender.newBuilder().setName(writer.name)).setLayout(((Appender)existing.getValue()).getLayout())).setTarget((Writer)writer).build();
        writerAppender.start();
        config.getRootLogger().addAppender((Appender)writerAppender, level, null);
        return writer;
    }

    private static void removeWriterAppender(ConcurrentStringWriter writer, LoggerContext context) {
        Configuration config = context.getConfiguration();
        LoggerConfig rootConfig = config.getRootLogger();
        WriterAppender writerAppender = (WriterAppender)rootConfig.getAppenders().get(writer.name);
        if (writerAppender != null) {
            writerAppender.stop(0L, TimeUnit.NANOSECONDS);
        }
        rootConfig.removeAppender(writer.name);
    }

    private static final class ConcurrentStringWriter
    extends Writer {
        private static final String APPENDER_NAME_PREFIX = "writer";
        private final StringWriter stringWriter = new StringWriter();
        final String name = "writer_" + UUID.randomUUID();

        private ConcurrentStringWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            StringWriter stringWriter = this.stringWriter;
            synchronized (stringWriter) {
                this.stringWriter.write(cbuf, off, len);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringWriter stringWriter = this.stringWriter;
            synchronized (stringWriter) {
                return this.stringWriter.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            StringWriter stringWriter = this.stringWriter;
            synchronized (stringWriter) {
                this.stringWriter.getBuffer().setLength(0);
            }
        }
    }
}

