/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.log4j2.mdc.utils;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggerStringWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerStringWriter.class);
    private static final String APPENDER_NAME = "writer";
    @Nullable
    private static StringWriter logStringWriter;

    private LoggerStringWriter() {
    }

    public static void reset() {
        LoggerStringWriter.getStringWriter().getBuffer().setLength(0);
    }

    public static void remove() {
        LoggerStringWriter.removeStringWriter();
    }

    public static String accumulated() {
        return LoggerStringWriter.getStringWriter().toString();
    }

    public static String stableAccumulated(int totalWaitTimeMillis) throws InterruptedException, TimeoutException {
        return LoggerStringWriter.stableAccumulated(totalWaitTimeMillis, 10L);
    }

    public static String stableAccumulated(int totalWaitTimeMillis, long sleepDurationMs) throws InterruptedException, TimeoutException {
        long nanoTimeB;
        String logContent;
        String forcedLogEntry = "forced log entry to help for flush on current thread " + ThreadLocalRandom.current().nextLong();
        LOGGER.error(forcedLogEntry);
        String newLogContent = logContent = LoggerStringWriter.accumulated();
        long nanoTimeA = System.nanoTime();
        while (!logContent.contains(forcedLogEntry)) {
            if (totalWaitTimeMillis <= 0) {
                throw new TimeoutException("timed out waiting for thread: " + Thread.currentThread());
            }
            Thread.sleep(sleepDurationMs);
            nanoTimeB = System.nanoTime();
            totalWaitTimeMillis = (int)((long)totalWaitTimeMillis - TimeUnit.NANOSECONDS.toMillis(nanoTimeB - nanoTimeA));
            nanoTimeA = nanoTimeB;
            logContent = newLogContent = LoggerStringWriter.accumulated();
        }
        do {
            logContent = newLogContent;
            if (totalWaitTimeMillis <= 0) {
                throw new TimeoutException("timed out waiting for thread: " + Thread.currentThread());
            }
            Thread.sleep(sleepDurationMs);
            nanoTimeB = System.nanoTime();
            totalWaitTimeMillis = (int)((long)totalWaitTimeMillis - TimeUnit.NANOSECONDS.toMillis(nanoTimeB - nanoTimeA));
            nanoTimeA = nanoTimeB;
        } while (!(newLogContent = LoggerStringWriter.accumulated()).equals(logContent));
        return logContent;
    }

    public static void assertContainsMdcPair(String value, String expectedLabel, String expectedValue) {
        int x = value.indexOf(expectedLabel);
        MatcherAssert.assertThat((String)("couldn't find expectedLabel: " + expectedLabel), (Object)x, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))));
        int beginIndex = x + expectedLabel.length();
        MatcherAssert.assertThat((Object)value.substring(beginIndex, beginIndex + expectedValue.length()), (Matcher)CoreMatchers.is((Object)expectedValue));
    }

    private static synchronized StringWriter getStringWriter() {
        if (logStringWriter == null) {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            logStringWriter = LoggerStringWriter.addWriterAppender(context, Level.DEBUG);
        }
        return logStringWriter;
    }

    private static synchronized void removeStringWriter() {
        if (logStringWriter == null) {
            return;
        }
        LoggerStringWriter.removeWriterAppender((LoggerContext)LogManager.getContext((boolean)false));
        logStringWriter = null;
    }

    private static StringWriter addWriterAppender(LoggerContext context, Level level) {
        Configuration config = context.getConfiguration();
        StringWriter writer = new StringWriter();
        Map.Entry existing = config.getAppenders().entrySet().iterator().next();
        WriterAppender writerAppender = ((WriterAppender.Builder)((WriterAppender.Builder)WriterAppender.newBuilder().setName(APPENDER_NAME)).setLayout(((Appender)existing.getValue()).getLayout())).setTarget((Writer)writer).build();
        writerAppender.start();
        config.getRootLogger().addAppender((Appender)writerAppender, level, null);
        return writer;
    }

    private static void removeWriterAppender(LoggerContext context) {
        Configuration config = context.getConfiguration();
        LoggerConfig rootConfig = config.getRootLogger();
        WriterAppender writerAppender = (WriterAppender)rootConfig.getAppenders().get(APPENDER_NAME);
        if (writerAppender != null) {
            writerAppender.stop(0L, TimeUnit.NANOSECONDS);
        }
        rootConfig.removeAppender(APPENDER_NAME);
    }
}

