/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey.resources;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CompositeBuffer;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.DeliberateException;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.router.jersey.AbstractResourceTest;
import io.servicetalk.http.router.jersey.TestPojo;
import io.servicetalk.http.router.jersey.TestUtils;
import io.servicetalk.http.router.jersey.resources.AsynchronousResources;
import io.servicetalk.http.router.jersey.resources.SerializerUtils;
import io.servicetalk.transport.api.ConnectionContext;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

@Path(value="/sync")
public class SynchronousResources {
    public static final String PATH = "/sync";
    @Context
    private ConnectionContext ctx;

    @Produces(value={"text/plain"})
    @Path(value="/uris/{type:(relative|absolute)}")
    @GET
    public String getUri(@PathParam(value="type") String uriType, @Context UriInfo uriInfo) {
        if (uriType.charAt(0) == 'a') {
            return uriInfo.getAbsolutePathBuilder().build(new Object[0]).toString();
        }
        return UriBuilder.fromResource(AsynchronousResources.class).path("/text").build(new Object[0]).toString();
    }

    @Path(value="/statuses/444")
    @GET
    public Response get444Status() {
        return Response.status((int)444, (String)"Three fours!").build();
    }

    @Produces(value={"text/plain"})
    @Path(value="/matrix/{pathSegment:ps}/params")
    @GET
    public String objectsByCategory(@PathParam(value="pathSegment") PathSegment pathSegment, @MatrixParam(value="mp") List<String> matrixParams) {
        MultivaluedMap matrixParameters = pathSegment.getMatrixParameters();
        String categorySegmentPath = pathSegment.getPath();
        return "GOT: " + matrixParameters.keySet().stream().map(k -> k + "=" + ((List)matrixParameters.get(k)).stream().collect(Collectors.joining(","))).collect(Collectors.joining(",")) + " & " + categorySegmentPath + " & " + matrixParams.stream().collect(Collectors.joining(","));
    }

    @Produces(value={"text/plain"})
    @Path(value="/bogus-chunked")
    @GET
    public Response bogusChunked() {
        return Response.ok((Object)"foo").header("Transfer-Encoding", (Object)"chunked").build();
    }

    @Produces(value={"text/plain"})
    @Path(value="/servicetalk-request")
    @GET
    public String serviceTalkRequest(@Context StreamingHttpRequest serviceTalkRequest) {
        return "GOT: " + serviceTalkRequest.requestTarget();
    }

    @Produces(value={"text/plain"})
    @Path(value="/head")
    @HEAD
    public Response explicitHead(String requestContent) {
        return Response.accepted().header("Content-Length", (Object)"123").build();
    }

    @Produces(value={"text/plain"})
    @Path(value="/text")
    @GET
    public String getText(@Nullable @QueryParam(value="qp") String qp, @QueryParam(value="null") boolean nullResult, @Nullable @HeaderParam(value="hp") String hp) {
        if ("throw-not-translated".equals(qp)) {
            throw DeliberateException.DELIBERATE_EXCEPTION;
        }
        if ("throw-translated".equals(qp)) {
            throw new WebApplicationException("Deliberate Exception", Response.Status.CONFLICT);
        }
        return nullResult ? null : "GOT: " + qp + " & " + hp;
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/text")
    @POST
    public String postText(String requestContent) {
        return "GOT: " + requestContent;
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-response")
    @GET
    public Response getTextResponse(@Context HttpHeaders headers) {
        return Response.noContent().header("X-Test", (Object)headers.getHeaderString("hdr")).build();
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-response")
    @POST
    public Response postTextResponse(String requestContent) {
        return Response.accepted((Object)("GOT: " + requestContent)).build();
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-buffer")
    @GET
    public Buffer getTextBuffer() {
        return this.ctx.executionContext().bufferAllocator().fromAscii((CharSequence)"DONE");
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/text-buffer")
    @POST
    public Buffer postTextBuffer(Buffer requestContent) {
        BufferAllocator allocator = this.ctx.executionContext().bufferAllocator();
        CompositeBuffer cb = allocator.newCompositeBuffer(2);
        return cb.addBuffer(allocator.fromAscii((CharSequence)"GOT: ")).addBuffer(requestContent);
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-buffer")
    @POST
    public Buffer postJsonBuffer(Buffer requestContent) {
        BufferAllocator allocator = this.ctx.executionContext().bufferAllocator();
        CompositeBuffer cb = allocator.newCompositeBuffer(3);
        return cb.addBuffer(allocator.fromAscii((CharSequence)"{\"got\":")).addBuffer(requestContent).addBuffer(allocator.fromAscii((CharSequence)"}"));
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/text-bytes")
    @POST
    public byte[] postTextBytes(byte[] requestContent) {
        byte[] responseContent = new byte[requestContent.length + 5];
        System.arraycopy("GOT: ".getBytes(StandardCharsets.US_ASCII), 0, responseContent, 0, 5);
        System.arraycopy(requestContent, 0, responseContent, 5, requestContent.length);
        return responseContent;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-bytes")
    @POST
    public byte[] postJsonBytes(byte[] requestContent) {
        byte[] responseContent = new byte[requestContent.length + 8];
        System.arraycopy("{\"got\":".getBytes(StandardCharsets.US_ASCII), 0, responseContent, 0, 7);
        System.arraycopy(requestContent, 0, responseContent, 7, requestContent.length);
        responseContent[requestContent.length + 7] = 125;
        return responseContent;
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-buffer-response")
    @GET
    public Response getTextBufferResponse(@Context HttpHeaders headers) {
        return Response.status((int)203).entity((Object)this.ctx.executionContext().bufferAllocator().fromAscii((CharSequence)"DONE")).header("X-Test", (Object)headers.getHeaderString("hdr")).build();
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-buffer-response")
    @POST
    public Response postTextBufferResponse(Buffer requestContent) {
        return Response.accepted((Object)this.postTextBuffer(requestContent)).build();
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/text-strin-pubout")
    @POST
    public Publisher<Buffer> postTextStrInPubOut(String requestContent) {
        return Publisher.from((Object)this.ctx.executionContext().bufferAllocator().fromUtf8((CharSequence)("GOT: " + requestContent)));
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/text-pubin-strout")
    @POST
    public String postTextPubInStrOut(Publisher<Buffer> requestContent) {
        return "GOT: " + TestUtils.getContentAsString(requestContent);
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/text-pubin-pubout")
    @POST
    public Publisher<Buffer> postTextPubInPubOut(Publisher<Buffer> requestContent) {
        return Publisher.from((Object)this.ctx.executionContext().bufferAllocator().fromAscii((CharSequence)"GOT: ")).concat(requestContent);
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-pub-response")
    @GET
    public Response getTextPubResponse(@QueryParam(value="i") int i) {
        String contentString = "GOT: " + i;
        Publisher responseContent = Publisher.from((Object)this.ctx.executionContext().bufferAllocator().fromAscii((CharSequence)contentString));
        return Response.status((int)i).header("Content-Length", (Object)contentString.length()).entity((Object)new GenericEntity<Publisher<Buffer>>(responseContent){}).build();
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/text-oio-streams")
    @POST
    public StreamingOutput postTextOioStreams(InputStream requestContent) {
        return output -> {
            int b;
            output.write("GOT: ".getBytes(StandardCharsets.UTF_8));
            while ((b = requestContent.read()) >= 0) {
                output.write(b);
            }
            output.flush();
        };
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-oio-streams")
    @POST
    public StreamingOutput postJsonOioStreams(InputStream requestContent) {
        return output -> {
            int b;
            output.write("{\"got\":".getBytes(StandardCharsets.UTF_8));
            while ((b = requestContent.read()) >= 0) {
                output.write(b);
            }
            output.write(125);
            output.flush();
        };
    }

    @AbstractResourceTest.TestFiltered
    @Produces(value={"text/plain"})
    @Path(value="/filtered")
    @POST
    public String filtered(String requestContent) {
        return "GOT: " + requestContent;
    }

    @Produces(value={"application/json"})
    @Path(value="/json")
    @GET
    public Map<String, Object> getJson() {
        return Collections.singletonMap("foo", "bar0");
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json")
    @POST
    public Map<String, Object> postJson(Map<String, Object> requestContent) {
        HashMap<String, Object> responseContent = new HashMap<String, Object>(requestContent);
        responseContent.put("foo", "bar1");
        return responseContent;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-response")
    @PUT
    public Response putJsonResponse(Map<String, Object> requestContent) {
        HashMap<String, Object> responseContent = new HashMap<String, Object>(requestContent);
        responseContent.put("foo", "bar2");
        return Response.accepted(responseContent).header("X-Test", (Object)"test-header").build();
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-mapin-pubout")
    @POST
    public Publisher<Buffer> postJsonMapInPubOut(Map<String, Object> requestContent) {
        HashMap<String, Object> responseContent = new HashMap<String, Object>(requestContent);
        responseContent.put("foo", "bar3");
        return SerializerUtils.MAP_STRING_OBJECT_STREAM_SERIALIZER.serialize(Publisher.from(responseContent), this.ctx.executionContext().bufferAllocator());
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-pubin-mapout")
    @POST
    public Map<String, Object> postJsonPubInMapOut(Publisher<Buffer> requestContent) {
        Map requestData = (Map)SerializerUtils.MAP_STRING_OBJECT_STREAM_SERIALIZER.deserialize(requestContent, this.ctx.executionContext().bufferAllocator()).toIterable().iterator().next();
        HashMap<String, Object> responseContent = new HashMap<String, Object>(requestData);
        responseContent.put("foo", "bar4");
        return responseContent;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-pubin-pubout")
    @POST
    public Publisher<Buffer> postJsonPubInPubOut(Publisher<Buffer> requestContent) {
        Publisher response = SerializerUtils.MAP_STRING_OBJECT_STREAM_SERIALIZER.deserialize(requestContent, this.ctx.executionContext().bufferAllocator()).map(requestData -> {
            HashMap<String, String> responseContent = new HashMap<String, String>((Map<String, String>)requestData);
            responseContent.put("foo", "bar5");
            return responseContent;
        });
        return SerializerUtils.MAP_STRING_OBJECT_STREAM_SERIALIZER.serialize(response, this.ctx.executionContext().bufferAllocator());
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-buf-sglin-sglout-response")
    @POST
    public Response postJsonBufSingleInSingleOutResponse(Single<Buffer> requestContent) {
        BufferAllocator allocator = this.ctx.executionContext().bufferAllocator();
        Single response = requestContent.map(buf -> {
            HashMap<String, String> responseContent = new HashMap<String, String>((Map)SerializerUtils.MAP_STRING_OBJECT_SERIALIZER.deserialize(buf, allocator));
            responseContent.put("foo", "bar6");
            return SerializerUtils.MAP_STRING_OBJECT_SERIALIZER.serialize(responseContent, allocator);
        });
        return Response.accepted((Object)new GenericEntity<Single<Buffer>>(response){}).build();
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-buf-pubin-pubout")
    @POST
    public Publisher<Buffer> postJsonBufPubInPubOut(Publisher<Buffer> requestContent) {
        BufferAllocator allocator = this.ctx.executionContext().bufferAllocator();
        return requestContent.map(buf -> allocator.fromUtf8((CharSequence)buf.toString(StandardCharsets.UTF_8).toUpperCase(Locale.ENGLISH)));
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-buf-pubin-pubout-response")
    @POST
    public Response postJsonBufPubInPubOutResponse(Publisher<Buffer> requestContent) {
        return Response.accepted((Object)new GenericEntity<Publisher<Buffer>>(this.postJsonBufPubInPubOut(requestContent)){}).build();
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-pojoin-pojoout")
    @POST
    public TestPojo postJsonPojoInPojoOut(TestPojo testPojo) {
        testPojo.setAnInt(testPojo.getAnInt() + 1);
        testPojo.setaString(testPojo.getaString() + "x");
        return testPojo;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-pojoin-pojoout-response")
    @POST
    public Response postJsonPojoInPojoOutResponse(TestPojo testPojo) {
        testPojo.setAnInt(testPojo.getAnInt() + 1);
        testPojo.setaString(testPojo.getaString() + "x");
        return Response.accepted((Object)testPojo).build();
    }

    @Produces(value={"application/json"})
    @Path(value="/security-context")
    @GET
    public SecurityContext securityContext(@Context SecurityContext securityContext) {
        return securityContext;
    }
}

