/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey.resources;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.router.jersey.resources.SerializerUtils;
import io.servicetalk.router.api.NoOffloadsRouteExecutionStrategy;
import io.servicetalk.router.api.RouteExecutionStrategy;
import io.servicetalk.transport.api.ConnectionContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseEventSink;
import org.glassfish.jersey.server.ManagedAsync;

public final class ExecutionStrategyResources {
    public static final String EXEC_NAME = "exec";
    public static final String RS_THREAD_NAME = "rs-thread";
    public static final String THREAD_NAME = "thread";

    private ExecutionStrategyResources() {
    }

    @RouteExecutionStrategy(id="test")
    @Path(value="/rsc-unsupported-async")
    public static class ResourceUnsupportedAsync {
        @GET
        @Path(value="/suspended")
        public void suspended(@Suspended AsyncResponse ar) {
            ar.resume((Object)"DONE");
        }

        @Produces(value={"text/event-stream"})
        @GET
        @Path(value="/sse")
        public void sse(@Context SseEventSink eventSink, @Context Sse sse) {
        }

        @ManagedAsync
        @GET
        @Path(value="/managed")
        public void managed() {
        }

        @GET
        @Path(value="/cf")
        public CompletionStage<String> cf() {
            return CompletableFuture.completedFuture("DONE");
        }
    }

    @Path(value="/rsc-invalid")
    public static class ResourceInvalidExecStrategy {
        @RouteExecutionStrategy(id="")
        @GET
        @Path(value="/empty-id")
        public void emptyId() {
        }

        @NoOffloadsRouteExecutionStrategy
        @RouteExecutionStrategy(id="test")
        @GET
        @Path(value="/conflicting")
        public void conflictingAnnotations() {
        }
    }

    @NoOffloadsRouteExecutionStrategy
    @Path(value="/rsc-rte-no-offloads")
    public static class ResourceRouteNoOffloadsStrategy
    extends AbstractExecutionStrategyResource {
    }

    @RouteExecutionStrategy(id="test")
    @Path(value="/rsc-rte-exec-id")
    public static class ResourceRouteExecIdStrategy
    extends AbstractExecutionStrategyResource {
    }

    @Path(value="/rsc-default")
    public static class ResourceDefaultStrategy
    extends AbstractExecutionStrategyResource {
    }

    @Produces(value={"application/json"})
    public static abstract class AbstractExecutionStrategyResource {
        @Context
        private ConnectionContext ctx;
        @Context
        private StreamingHttpRequest req;
        @Context
        private UriInfo uriInfo;

        @GET
        @Path(value="/subrsc-default")
        public Map<String, String> subResourceDefault() {
            return AbstractExecutionStrategyResource.getThreadingInfo(this.ctx, this.req, this.uriInfo);
        }

        @GET
        @Path(value="/subrsc-default-single")
        public Single<Map<String, String>> subResourceDefaultSingle() {
            return this.getThreadingInfoSingle();
        }

        @GET
        @Path(value="/subrsc-default-single-response")
        public Single<Response> subResourceDefaultSingleResponse() {
            return this.getThreadingInfoSingleResponse();
        }

        @GET
        @Path(value="/subrsc-default-single-buffer")
        public Single<Buffer> subResourceDefaultSingleBuffer() {
            return this.getThreadingInfoSingleBuffer();
        }

        @Consumes(value={"application/json"})
        @POST
        @Path(value="/subrsc-default-single-mapped")
        public Single<Map<String, String>> subResourceDefaultSingleMapped(Single<Buffer> body) {
            return this.getThreadingInfoSingleMapped(body);
        }

        @Consumes(value={"application/json"})
        @POST
        @Path(value="/subrsc-default-publisher-mapped")
        public Publisher<Buffer> subResourceDefaultPubMapped(Publisher<Buffer> body) {
            return this.getThreadingInfoPublisherMapped(body);
        }

        @RouteExecutionStrategy(id="test")
        @GET
        @Path(value="/subrsc-rte-exec-id")
        public Map<String, String> subResourceRouteExecId() {
            return AbstractExecutionStrategyResource.getThreadingInfo(this.ctx, this.req, this.uriInfo);
        }

        @RouteExecutionStrategy(id="test")
        @GET
        @Path(value="/subrsc-rte-exec-id-single")
        public Single<Map<String, String>> subResourceRouteExecIdSingle() {
            return this.getThreadingInfoSingle();
        }

        @RouteExecutionStrategy(id="test")
        @GET
        @Path(value="/subrsc-rte-exec-id-single-response")
        public Single<Response> subResourceRouteExecIdSingleResponse() {
            return this.getThreadingInfoSingleResponse();
        }

        @RouteExecutionStrategy(id="test")
        @GET
        @Path(value="/subrsc-rte-exec-id-single-buffer")
        public Single<Buffer> subResourceRouteExecIdSingleBuffer() {
            return this.getThreadingInfoSingleBuffer();
        }

        @RouteExecutionStrategy(id="test")
        @Consumes(value={"application/json"})
        @POST
        @Path(value="/subrsc-rte-exec-id-single-mapped")
        public Single<Map<String, String>> subResourceRouteExecIdSingleMapped(Single<Buffer> body) {
            return this.getThreadingInfoSingleMapped(body);
        }

        @RouteExecutionStrategy(id="test")
        @Consumes(value={"application/json"})
        @POST
        @Path(value="/subrsc-rte-exec-id-publisher-mapped")
        public Publisher<Buffer> subResourceRouteExecIdPubMapped(Publisher<Buffer> body) {
            return this.getThreadingInfoPublisherMapped(body);
        }

        @NoOffloadsRouteExecutionStrategy
        @GET
        @Path(value="/subrsc-rte-no-offloads")
        public Map<String, String> subResourceRouteNoOffloads() {
            return AbstractExecutionStrategyResource.getThreadingInfo(this.ctx, this.req, this.uriInfo);
        }

        @NoOffloadsRouteExecutionStrategy
        @GET
        @Path(value="/subrsc-rte-no-offloads-single")
        public Single<Map<String, String>> subResourceRouteNoOffloadsSingle() {
            return this.getThreadingInfoSingle();
        }

        @NoOffloadsRouteExecutionStrategy
        @GET
        @Path(value="/subrsc-rte-no-offloads-single-response")
        public Single<Response> subResourceRouteNoOffloadsSingleResponse() {
            return this.getThreadingInfoSingleResponse();
        }

        @NoOffloadsRouteExecutionStrategy
        @GET
        @Path(value="/subrsc-rte-no-offloads-single-buffer")
        public Single<Buffer> subResourceRouteNoOffloadsSingleBuffer() {
            return this.getThreadingInfoSingleBuffer();
        }

        @NoOffloadsRouteExecutionStrategy
        @Consumes(value={"application/json"})
        @POST
        @Path(value="/subrsc-rte-no-offloads-single-mapped")
        public Single<Map<String, String>> subResourceRouteNoOffloadsSingleMapped(Single<Buffer> body) {
            return this.getThreadingInfoSingleMapped(body);
        }

        @NoOffloadsRouteExecutionStrategy
        @Consumes(value={"application/json"})
        @POST
        @Path(value="/subrsc-rte-no-offloads-publisher-mapped")
        public Publisher<Buffer> subResourceRouteNoOffloadsPubMapped(Publisher<Buffer> body) {
            return this.getThreadingInfoPublisherMapped(body);
        }

        private Single<Map<String, String>> getThreadingInfoSingle() {
            Map<String, String> threadingInfo = AbstractExecutionStrategyResource.getThreadingInfo(this.ctx, this.req, this.uriInfo);
            return Single.defer(() -> {
                threadingInfo.put(ExecutionStrategyResources.RS_THREAD_NAME, Thread.currentThread().getName());
                return Single.succeeded((Object)threadingInfo);
            });
        }

        private Single<Response> getThreadingInfoSingleResponse() {
            Map<String, String> threadingInfo = AbstractExecutionStrategyResource.getThreadingInfo(this.ctx, this.req, this.uriInfo);
            return Single.defer(() -> {
                threadingInfo.put(ExecutionStrategyResources.RS_THREAD_NAME, Thread.currentThread().getName());
                return Single.succeeded((Object)Response.ok((Object)threadingInfo).build());
            });
        }

        private Single<Buffer> getThreadingInfoSingleBuffer() {
            BufferAllocator allocator = this.ctx.executionContext().bufferAllocator();
            Map<String, String> threadingInfo = AbstractExecutionStrategyResource.getThreadingInfo(this.ctx, this.req, this.uriInfo);
            return Single.defer(() -> {
                threadingInfo.put(ExecutionStrategyResources.RS_THREAD_NAME, Thread.currentThread().getName());
                return Single.succeeded((Object)SerializerUtils.MAP_STRING_STRING_SERIALIZER.serialize((Object)threadingInfo, allocator));
            });
        }

        private Single<Map<String, String>> getThreadingInfoSingleMapped(Single<Buffer> content) {
            Map<String, String> threadingInfo = AbstractExecutionStrategyResource.getThreadingInfo(this.ctx, this.req, this.uriInfo);
            return content.flatMap(__ -> {
                threadingInfo.put(ExecutionStrategyResources.RS_THREAD_NAME, Thread.currentThread().getName());
                return Single.succeeded((Object)threadingInfo);
            });
        }

        private Publisher<Buffer> getThreadingInfoPublisherMapped(Publisher<Buffer> content) {
            return content.ignoreElements().concat(this.getThreadingInfoSingleBuffer().toPublisher());
        }

        private static Map<String, String> getThreadingInfo(ConnectionContext ctx, StreamingHttpRequest req, UriInfo uriInfo) {
            if (!req.path().equals('/' + uriInfo.getPath())) {
                throw new IllegalStateException("Invalid @context state for: " + req);
            }
            HashMap<String, String> info = new HashMap<String, String>(2);
            info.put(ExecutionStrategyResources.THREAD_NAME, Thread.currentThread().getName());
            info.put(ExecutionStrategyResources.EXEC_NAME, ctx.executionContext().executor().toString());
            return info;
        }
    }
}

