/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey.resources;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CompositeBuffer;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.router.jersey.TestUtils;
import io.servicetalk.router.api.NoOffloadsRouteExecutionStrategy;
import io.servicetalk.router.api.RouteExecutionStrategy;
import io.servicetalk.transport.api.ConnectionContext;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseEventSink;

@Path(value="/cancel")
public class CancellableResources {
    public static final String PATH = "/cancel";
    public final CountDownLatch sseSinkClosedLatch = new CountDownLatch(1);

    @Path(value="/suspended")
    @GET
    public void getForeverSuspended(@Suspended AsyncResponse ar) {
        ar.setTimeout(7L, TimeUnit.DAYS);
    }

    @Produces(value={"text/plain"})
    @Path(value="/single")
    @GET
    public Single<String> getSingleNever() {
        return Single.never();
    }

    @RouteExecutionStrategy(id="test")
    @Produces(value={"text/plain"})
    @Path(value="/offload")
    @GET
    public String getOffloadedBlocked() throws InterruptedException {
        Thread.sleep(TimeUnit.DAYS.toMillis(7L));
        return "never reached";
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/oio-streams")
    @POST
    public StreamingOutput postOioStreams(InputStream requestContent) {
        return output -> {
            int b;
            output.write("GOT: ".getBytes(StandardCharsets.UTF_8));
            while ((b = requestContent.read()) >= 0) {
                output.write(b);
            }
            output.flush();
        };
    }

    @RouteExecutionStrategy(id="test")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/offload-oio-streams")
    @POST
    public StreamingOutput postOffloadedOioStreams(InputStream requestContent) {
        return this.postOioStreams(requestContent);
    }

    @NoOffloadsRouteExecutionStrategy
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/no-offloads-oio-streams")
    @POST
    public StreamingOutput postNoOffloadsOioStreams(InputStream requestContent) {
        return this.postOioStreams(requestContent);
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/rs-streams")
    @POST
    public Publisher<Buffer> postRsStreams(@QueryParam(value="subscribe") boolean subscribe, Publisher<Buffer> requestContent, @Context ConnectionContext ctx) {
        BufferAllocator allocator = ctx.executionContext().bufferAllocator();
        CompositeBuffer responseBuffer = allocator.newCompositeBuffer(2).addBuffer(allocator.fromAscii((CharSequence)"GOT: "));
        if (subscribe) {
            return Publisher.from((Object)responseBuffer.writeAscii((CharSequence)TestUtils.getContentAsString(requestContent)));
        }
        AtomicBoolean first = new AtomicBoolean(true);
        return requestContent.map(c -> first.compareAndSet(true, false) ? responseBuffer.addBuffer(c) : c);
    }

    @RouteExecutionStrategy(id="test")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/offload-rs-streams")
    @POST
    public Publisher<Buffer> postOffloadedRsStreams(@QueryParam(value="subscribe") boolean subscribe, Publisher<Buffer> requestContent, @Context ConnectionContext ctx) {
        return this.postRsStreams(subscribe, requestContent, ctx);
    }

    @NoOffloadsRouteExecutionStrategy
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/no-offloads-rs-streams")
    @POST
    public Publisher<Buffer> postNoOffloadsRsStreams(@QueryParam(value="subscribe") boolean subscribe, Publisher<Buffer> requestContent, @Context ConnectionContext ctx) {
        return this.postRsStreams(subscribe, requestContent, ctx);
    }

    @Produces(value={"text/event-stream"})
    @Path(value="/sse")
    @GET
    public void getSseStream(@Context SseEventSink eventSink, @Context Sse sse, @Context ConnectionContext ctx) {
        this.sendSseUntilFailure(eventSink, sse, ctx.executionContext().executor());
    }

    private void sendSseUntilFailure(SseEventSink eventSink, Sse sse, Executor executor) {
        try {
            eventSink.send(sse.newEvent("foo"));
            executor.schedule(() -> this.sendSseUntilFailure(eventSink, sse, executor), 10L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t) {
            if (eventSink.isClosed()) {
                this.sseSinkClosedLatch.countDown();
            }
            throw new IllegalStateException("SseEventSink should be closed", t);
        }
    }
}

