/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey.resources;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.DeliberateException;
import io.servicetalk.http.router.jersey.AbstractResourceTest;
import io.servicetalk.http.router.jersey.TestPojo;
import io.servicetalk.http.router.jersey.resources.SerializerUtils;
import io.servicetalk.transport.api.ConnectionContext;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.sse.OutboundSseEvent;
import javax.ws.rs.sse.Sse;
import javax.ws.rs.sse.SseBroadcaster;
import javax.ws.rs.sse.SseEventSink;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Refs;

@Path(value="/async")
public class AsynchronousResources {
    public static final String PATH = "/async";
    @Context
    private ConnectionContext ctx;

    @AbstractResourceTest.TestFiltered
    @Path(value="/completable")
    @GET
    public Completable getCompletableOut(@QueryParam(value="fail") boolean fail) {
        return Completable.defer(() -> fail ? Completable.failed((Throwable)DeliberateException.DELIBERATE_EXCEPTION) : Completable.completed());
    }

    @Produces(value={"text/plain"})
    @Path(value="/single-string")
    @GET
    public Single<String> getStringSingle(@QueryParam(value="fail") boolean fail) {
        return this.ctx.executionContext().executor().timer(10L, TimeUnit.MILLISECONDS).concat(fail ? Single.failed((Throwable)DeliberateException.DELIBERATE_EXCEPTION) : Single.succeeded((Object)"DONE"));
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-buf-sglin-sglout")
    @POST
    public Single<Buffer> postJsonBufSingleInSingleOut(@QueryParam(value="fail") boolean fail, Single<Buffer> requestContent) {
        BufferAllocator allocator = this.ctx.executionContext().bufferAllocator();
        return fail ? Single.defer(() -> Single.failed((Throwable)DeliberateException.DELIBERATE_EXCEPTION)) : requestContent.map(buf -> {
            HashMap<String, String> responseContent = new HashMap<String, String>((Map)SerializerUtils.MAP_STRING_OBJECT_SERIALIZER.deserialize(buf, allocator));
            responseContent.put("foo", "bar6");
            return SerializerUtils.MAP_STRING_OBJECT_SERIALIZER.serialize(responseContent, allocator);
        });
    }

    @Produces(value={"text/plain"})
    @Path(value="/single-response")
    @GET
    public Single<Response> getResponseSingle(@QueryParam(value="fail") boolean fail) {
        return this.ctx.executionContext().executor().timer(10L, TimeUnit.MILLISECONDS).concat(fail ? Single.failed((Throwable)DeliberateException.DELIBERATE_EXCEPTION) : Single.succeeded((Object)Response.accepted((Object)"DONE").build()));
    }

    @Produces(value={"text/plain"})
    @Path(value="/single-response-pub-entity")
    @GET
    public Single<Response> getResponseSinglePublisherEntity(@QueryParam(value="i") int i) {
        BufferAllocator allocator = this.ctx.executionContext().bufferAllocator();
        return this.ctx.executionContext().executor().timer(10L, TimeUnit.MILLISECONDS).concat(Single.defer(() -> {
            String contentString = "GOT: " + i;
            Publisher responseContent = Publisher.from((Object)allocator.fromAscii((CharSequence)contentString));
            return Single.succeeded((Object)Response.status((int)i).header("Content-Length", (Object)contentString.length()).entity((Object)new GenericEntity<Publisher<Buffer>>(responseContent){}).build());
        }));
    }

    @Produces(value={"application/json"})
    @Path(value="/single-map")
    @GET
    public Single<Map<String, Object>> getMapSingle(@QueryParam(value="fail") boolean fail) {
        return this.ctx.executionContext().executor().timer(10L, TimeUnit.MILLISECONDS).concat(fail ? Single.failed((Throwable)DeliberateException.DELIBERATE_EXCEPTION) : Single.defer(() -> Single.succeeded(Collections.singletonMap("foo", "bar4"))));
    }

    @Produces(value={"application/json"})
    @Path(value="/single-pojo")
    @GET
    public Single<TestPojo> getPojoSingle(@QueryParam(value="fail") boolean fail) {
        return this.ctx.executionContext().executor().timer(10L, TimeUnit.MILLISECONDS).concat(fail ? Single.failed((Throwable)DeliberateException.DELIBERATE_EXCEPTION) : Single.defer(() -> {
            TestPojo testPojo = new TestPojo();
            testPojo.setaString("boo");
            testPojo.setAnInt(456);
            return Single.succeeded((Object)testPojo);
        }));
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-pojoin-pojoout-single")
    @POST
    public Single<TestPojo> postJsonPojoInPojoOutSingle(@QueryParam(value="fail") boolean fail, TestPojo testPojo) {
        return this.ctx.executionContext().executor().timer(10L, TimeUnit.MILLISECONDS).concat(fail ? Single.failed((Throwable)DeliberateException.DELIBERATE_EXCEPTION) : Single.defer(() -> {
            testPojo.setAnInt(testPojo.getAnInt() + 1);
            testPojo.setaString(testPojo.getaString() + "x");
            return Single.succeeded((Object)testPojo);
        }));
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-pojoin-pojoout-response-single")
    @POST
    public Single<Response> postJsonPojoInPojoOutResponseSingle(@QueryParam(value="fail") boolean fail, TestPojo testPojo) {
        return this.ctx.executionContext().executor().timer(10L, TimeUnit.MILLISECONDS).concat(fail ? Single.failed((Throwable)DeliberateException.DELIBERATE_EXCEPTION) : Single.defer(() -> {
            testPojo.setAnInt(testPojo.getAnInt() + 1);
            testPojo.setaString(testPojo.getaString() + "x");
            return Single.succeeded((Object)Response.accepted((Object)testPojo).build());
        }));
    }

    @Path(value="/void-completion")
    @GET
    public CompletionStage<Void> getVoidCompletion(@QueryParam(value="fail") boolean fail, @QueryParam(value="defer") boolean defer) {
        Callable<Void> task = () -> {
            if (fail) {
                throw DeliberateException.DELIBERATE_EXCEPTION;
            }
            return null;
        };
        if (defer) {
            return this.newCompletionStage(task);
        }
        return this.newCompletedCompletionStage(task);
    }

    @Produces(value={"text/plain"})
    @Path(value="/head")
    @HEAD
    public CompletionStage<Response> explicitHead(String requestContent) {
        return this.newCompletionStage(() -> Response.accepted().header("Content-Length", (Object)"123").build());
    }

    @Produces(value={"text/plain"})
    @Path(value="/text")
    @GET
    public CompletionStage<String> getText(@Nullable @QueryParam(value="qp") String qp, @QueryParam(value="null") boolean nullResult, @Nullable @HeaderParam(value="hp") String hp) {
        if ("throw-not-translated".equals(qp)) {
            throw DeliberateException.DELIBERATE_EXCEPTION;
        }
        if ("throw-translated".equals(qp)) {
            throw new WebApplicationException("Deliberate Exception", Response.Status.CONFLICT);
        }
        return CompletableFuture.completedFuture(nullResult ? null : "GOT: " + qp + " & " + hp);
    }

    @Produces(value={"text/plain"})
    @Path(value="/failed-text")
    @GET
    public CompletionStage<String> getFailed(@QueryParam(value="cancel") boolean cancel) {
        CompletableFuture<String> cf = new CompletableFuture<String>();
        if (cancel) {
            cf.cancel(true);
        } else {
            cf.completeExceptionally((Throwable)DeliberateException.DELIBERATE_EXCEPTION);
        }
        return cf;
    }

    @Produces(value={"text/plain"})
    @Path(value="/delayed-text")
    @GET
    public CompletionStage<String> getDelayedText(@Nonnull @QueryParam(value="delay") long delay, @Nonnull @QueryParam(value="unit") TimeUnit unit) {
        return this.newCompletionStage(() -> "DONE", delay, unit);
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/text")
    @POST
    public CompletionStage<String> postText(String requestContent) {
        return CompletableFuture.completedFuture("GOT: " + requestContent);
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-response")
    @GET
    public CompletionStage<Response> getTextResponse(@Context HttpHeaders headers) {
        return CompletableFuture.completedFuture(Response.noContent().header("X-Test", (Object)headers.getHeaderString("hdr")).build());
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-response")
    @POST
    public CompletionStage<Response> postTextResponse(String requestContent) {
        return this.newCompletionStage(() -> Response.accepted((Object)("GOT: " + requestContent)).build());
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-buffer")
    @GET
    public CompletionStage<Buffer> getTextBuffer() {
        BufferAllocator allocator = this.ctx.executionContext().bufferAllocator();
        return this.newCompletionStage(() -> allocator.fromAscii((CharSequence)"DONE"));
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/text-buffer")
    @POST
    public CompletionStage<Buffer> postTextBuffer(Buffer requestContent) {
        BufferAllocator allocator = this.ctx.executionContext().bufferAllocator();
        return this.newCompletionStage(() -> allocator.newCompositeBuffer(2).addBuffer(allocator.fromAscii((CharSequence)"GOT: ")).addBuffer(requestContent));
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-buffer")
    @POST
    public CompletionStage<Buffer> postJsonBuffer(Buffer requestContent) {
        BufferAllocator allocator = this.ctx.executionContext().bufferAllocator();
        return this.newCompletionStage(() -> allocator.newCompositeBuffer(3).addBuffer(allocator.fromAscii((CharSequence)"{\"got\":")).addBuffer(requestContent).addBuffer(allocator.fromAscii((CharSequence)"}")));
    }

    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @Path(value="/text-bytes")
    @POST
    public CompletionStage<byte[]> postTextBytes(byte[] requestContent) {
        return this.newCompletionStage(() -> {
            byte[] responseContent = new byte[requestContent.length + 5];
            System.arraycopy("GOT: ".getBytes(StandardCharsets.US_ASCII), 0, responseContent, 0, 5);
            System.arraycopy(requestContent, 0, responseContent, 5, requestContent.length);
            return responseContent;
        });
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-bytes")
    @POST
    public CompletionStage<byte[]> postJsonBytes(byte[] requestContent) {
        return this.newCompletionStage(() -> {
            byte[] responseContent = new byte[requestContent.length + 8];
            System.arraycopy("{\"got\":".getBytes(StandardCharsets.US_ASCII), 0, responseContent, 0, 7);
            System.arraycopy(requestContent, 0, responseContent, 7, requestContent.length);
            responseContent[requestContent.length + 7] = 125;
            return responseContent;
        });
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-buffer-response")
    @GET
    public CompletionStage<Response> getTextBufferResponse(@Context HttpHeaders headers) {
        return CompletableFuture.completedFuture(Response.status((int)203).entity((Object)this.ctx.executionContext().bufferAllocator().fromAscii((CharSequence)"DONE")).header("X-Test", (Object)headers.getHeaderString("hdr")).build());
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-buffer-response")
    @POST
    public CompletionStage<Response> postTextBufferResponse(Buffer requestContent) {
        return this.postTextBuffer(requestContent).thenApply(b -> Response.accepted((Object)b).build());
    }

    @Produces(value={"text/plain"})
    @Path(value="/text-pub-response")
    @GET
    public CompletionStage<Response> getTextPubResponse(@QueryParam(value="i") int i) {
        String contentString = "GOT: " + i;
        Publisher responseContent = Publisher.from((Object)this.ctx.executionContext().bufferAllocator().fromAscii((CharSequence)contentString));
        return CompletableFuture.completedFuture(Response.status((int)i).header("Content-Length", (Object)contentString.length()).entity((Object)new GenericEntity<Publisher<Buffer>>(responseContent){}).build());
    }

    @Produces(value={"text/plain"})
    @Path(value="/response-comsta")
    @GET
    public Response getResponseCompletionStage(@Context HttpHeaders headers) {
        return Response.ok(CompletableFuture.completedFuture("DONE")).build();
    }

    @Produces(value={"text/plain"})
    @Path(value="/delayed-response-comsta")
    @GET
    public Response getDelayedResponseCompletionStage(@Nonnull @QueryParam(value="delay") long delay, @Nonnull @QueryParam(value="unit") TimeUnit unit) {
        CompletableFuture cf = new CompletableFuture();
        Cancellable cancellable = this.ctx.executionContext().executor().schedule(() -> cf.complete("DONE"), delay, unit);
        return Response.ok((Object)cf.whenComplete((r, t) -> {
            if (t instanceof CancellationException) {
                cancellable.cancel();
            }
        })).build();
    }

    @AbstractResourceTest.TestFiltered
    @Produces(value={"text/plain"})
    @Path(value="/filtered")
    @POST
    public CompletionStage<String> postFiltered(String requestContent) {
        return CompletableFuture.completedFuture("GOT: " + requestContent);
    }

    @Produces(value={"application/json"})
    @Path(value="/json")
    @GET
    public CompletionStage<Map<String, Object>> getJson() {
        return CompletableFuture.completedFuture(Collections.singletonMap("foo", "bar1"));
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json")
    @POST
    public CompletionStage<Map<String, Object>> postJson(Map<String, Object> requestContent) {
        HashMap<String, Object> responseContent = new HashMap<String, Object>(requestContent);
        responseContent.put("foo", "bar1");
        return CompletableFuture.completedFuture(responseContent);
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-response")
    @PUT
    public CompletionStage<Response> putJsonResponse(Map<String, Object> requestContent) {
        HashMap<String, Object> responseContent = new HashMap<String, Object>(requestContent);
        responseContent.put("foo", "bar2");
        return CompletableFuture.completedFuture(Response.accepted(responseContent).header("X-Test", (Object)"test-header").build());
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/json-pojoin-pojoout")
    @POST
    public CompletionStage<TestPojo> postJsonPojo(TestPojo testPojo) {
        testPojo.setAnInt(testPojo.getAnInt() + 1);
        testPojo.setaString(testPojo.getaString() + "x");
        return CompletableFuture.completedFuture(testPojo);
    }

    @Produces(value={"text/plain"})
    @Path(value="/suspended/resume")
    @GET
    public void getAsyncResponseResume(@Suspended AsyncResponse ar) {
        ar.resume((Object)"DONE");
    }

    @Produces(value={"text/plain"})
    @Path(value="/suspended/cancel")
    @GET
    public void getAsyncResponseCancel(@Suspended AsyncResponse ar) {
        ar.cancel();
    }

    @Produces(value={"text/plain"})
    @Path(value="/suspended/timeout-resume")
    @GET
    public void getAsyncResponseTimeoutResume(@Suspended AsyncResponse ar) {
        ar.setTimeout(1L, TimeUnit.MINUTES);
        this.ctx.executionContext().executor().timer(10L, TimeUnit.MILLISECONDS).afterOnComplete(() -> ar.resume((Object)"DONE")).subscribe();
    }

    @Produces(value={"text/plain"})
    @Path(value="/suspended/timeout-expire")
    @GET
    public void getAsyncResponseTimeoutExpire(@Suspended AsyncResponse ar) {
        ar.setTimeout(1L, TimeUnit.MINUTES);
        ar.setTimeout(1L, TimeUnit.NANOSECONDS);
    }

    @Produces(value={"text/plain"})
    @Path(value="/suspended/timeout-expire-handled")
    @GET
    public void getAsyncResponseTimeoutExpireHandled(@Suspended AsyncResponse ar) {
        ar.setTimeoutHandler(ar2 -> ar2.resume((Object)Response.status((Response.Status)Response.Status.GATEWAY_TIMEOUT).build()));
        ar.setTimeout(1L, TimeUnit.NANOSECONDS);
    }

    @Produces(value={"text/plain"})
    @Path(value="/suspended/resume-timeout")
    @GET
    public void getAsyncResponseResumeTimeout(@Suspended AsyncResponse ar) {
        ar.resume((Object)"DONE");
        ar.setTimeout(1L, TimeUnit.MINUTES);
    }

    @Produces(value={"text/plain"})
    @Path(value="/suspended/busy")
    @GET
    public void getAsyncResponseBusy(@Suspended AsyncResponse ar) {
    }

    @Produces(value={"application/json"})
    @Path(value="/suspended/json")
    @GET
    public void getJsonAsyncResponse(@Suspended AsyncResponse ar) {
        this.ctx.executionContext().executor().schedule(() -> ar.resume(Collections.singletonMap("foo", "bar3")), 10L, TimeUnit.MILLISECONDS);
    }

    @Produces(value={"text/event-stream"})
    @Path(value="/sse/stream")
    @GET
    public void getSseStream(final @Context SseEventSink eventSink, @Context Sse sse) {
        this.scheduleSseEventSend(new SseEmitter(){

            @Override
            public CompletionStage<?> emit(OutboundSseEvent event) {
                return eventSink.send(event);
            }

            @Override
            public void close() {
                eventSink.close();
            }
        }, sse, (Ref<Integer>)Refs.of((Object)0), this.ctx.executionContext().executor());
    }

    @Produces(value={"text/event-stream"})
    @Path(value="/sse/broadcast")
    @GET
    public void getSseBroadcast(@Context SseEventSink eventSink, @Context Sse sse) {
        eventSink.send(sse.newEvent("bar"));
        final SseBroadcaster sseBroadcaster = sse.newBroadcaster();
        sseBroadcaster.register(eventSink);
        this.scheduleSseEventSend(new SseEmitter(){

            @Override
            public CompletionStage<?> emit(OutboundSseEvent event) {
                return sseBroadcaster.broadcast(event);
            }

            @Override
            public void close() {
                sseBroadcaster.close();
            }
        }, sse, (Ref<Integer>)Refs.of((Object)0), this.ctx.executionContext().executor());
    }

    @Produces(value={"text/event-stream"})
    @Path(value="/sse/unsupported")
    @GET
    public void getSseUnsupportedType(@Context SseEventSink eventSink, @Context Sse sse) {
        eventSink.send(sse.newEventBuilder().data(Buffer.class, (Object)this.ctx.executionContext().bufferAllocator().fromAscii((CharSequence)"foo")).mediaType(MediaType.TEXT_PLAIN_TYPE).build());
    }

    private void scheduleSseEventSend(SseEmitter emmitter, Sse sse, Ref<Integer> iRef, Executor executor) {
        executor.schedule(() -> {
            int i = (Integer)iRef.get();
            emmitter.emit(sse.newEvent("foo" + i)).whenComplete((r, t) -> {
                if (t == null && i < 9) {
                    iRef.set((Object)(i + 1));
                    this.scheduleSseEventSend(emmitter, sse, iRef, executor);
                } else {
                    emmitter.close();
                }
            });
        }, 10L, TimeUnit.MILLISECONDS);
    }

    private <T> CompletionStage<T> newCompletedCompletionStage(Callable<T> task) {
        return this.newCompletionStage(task, 0L, TimeUnit.MILLISECONDS);
    }

    private <T> CompletionStage<T> newCompletionStage(Callable<T> task) {
        return this.newCompletionStage(task, 10L, TimeUnit.MILLISECONDS);
    }

    private <T> CompletionStage<T> newCompletionStage(Callable<T> task, long delay, TimeUnit unit) {
        CompletableFuture cf = new CompletableFuture();
        Runnable failSafeTask = () -> {
            try {
                cf.complete(task.call());
            }
            catch (Throwable t) {
                cf.completeExceptionally(t);
            }
        };
        if (delay == 0L) {
            failSafeTask.run();
            return cf;
        }
        Cancellable cancellable = this.ctx.executionContext().executor().schedule(failSafeTask, delay, unit);
        return cf.whenComplete((r, t) -> {
            if (t instanceof CancellationException) {
                cancellable.cancel();
            }
        });
    }

    private static interface SseEmitter {
        public CompletionStage<?> emit(OutboundSseEvent var1);

        public void close();
    }
}

