/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey.resources;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.netty.AsyncContextHttpFilterVerifier;
import io.servicetalk.transport.api.ConnectionContext;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

@Path(value="/asyncContext")
public class AsyncContextResources {
    public static final String PATH = "/asyncContext";
    @Context
    private ConnectionContext ctx;

    @GET
    @Path(value="/noArgsNoReturn")
    public void noArgsNoReturn() {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
    }

    @GET
    @Path(value="/getBuffer")
    @Produces(value={"text/plain"})
    public Buffer getBuffer() {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        return this.ctx.executionContext().bufferAllocator().fromUtf8((CharSequence)"foo");
    }

    @POST
    @Path(value="/postBuffer")
    @Consumes(value={"text/plain"})
    public void postBuffer(Buffer buffer) {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
    }

    @POST
    @Path(value="/syncEcho")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Buffer syncEcho(Buffer buffer) {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        return buffer;
    }

    @POST
    @Path(value="/syncEchoResponse")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response syncEchoResponse(Buffer buffer) {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        return Response.ok((Object)buffer).build();
    }

    @POST
    @Path(value="/postTextOioStreams")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public StreamingOutput postTextOioStreams(InputStream requestContent) {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        Scanner s = new Scanner(requestContent, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
        String result = s.hasNext() ? s.next() : "";
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K2, (Object)"v2");
        return output -> {
            output.write(result.getBytes(StandardCharsets.UTF_8));
            output.flush();
        };
    }

    @POST
    @Path(value="/syncEchoJsonMap")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, String> syncEchoJsonMap(Map<String, String> requestContent) {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        HashMap<String, String> responseContent = new HashMap<String, String>(requestContent);
        responseContent.put("foo", "bar1");
        return responseContent;
    }

    @GET
    @Path(value="/completable")
    public Completable completable() {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        return Completable.completed().beforeOnComplete(() -> {
            String cfr_ignored_0 = (String)AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K2, (Object)"v2");
        });
    }

    @GET
    @Path(value="/getSingleBuffer")
    @Produces(value={"text/plain"})
    public Single<Buffer> getSingleBuffer() {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        return Single.fromSupplier(() -> this.ctx.executionContext().bufferAllocator().fromUtf8((CharSequence)"foo")).beforeOnSuccess(__ -> {
            String cfr_ignored_0 = (String)AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K2, (Object)"v2");
        });
    }

    @POST
    @Path(value="/postSingleBuffer")
    @Consumes(value={"text/plain"})
    public Completable postSingleBuffer(Single<Buffer> in) {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        return in.toCompletable().beforeOnComplete(() -> {
            String cfr_ignored_0 = (String)AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K2, (Object)"v2");
        });
    }

    @POST
    @Path(value="/postSingleBufferSync")
    @Consumes(value={"text/plain"})
    public void postSingleBufferSync(Single<Buffer> in) {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        in.toCompletionStage().toCompletableFuture().join();
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K2, (Object)"v2");
    }

    @POST
    @Path(value="/singleEcho")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Single<Buffer> singleEcho(Single<Buffer> in) {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        return in.beforeOnSuccess(__ -> {
            String cfr_ignored_0 = (String)AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K2, (Object)"v2");
        });
    }

    @GET
    @Path(value="/getPublisherBuffer")
    @Produces(value={"text/plain"})
    public Publisher<Buffer> getPublisherBuffer() {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K2, (Object)"v2");
        return Publisher.from((Object)this.ctx.executionContext().bufferAllocator().fromUtf8((CharSequence)"foo")).beforeOnComplete(() -> {
            String cfr_ignored_0 = (String)AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K3, (Object)"v3");
        });
    }

    @POST
    @Path(value="/postPublisherBuffer")
    @Consumes(value={"text/plain"})
    public Completable postPublisherBuffer(Publisher<Buffer> in) {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        return in.ignoreElements().beforeOnComplete(() -> {
            String cfr_ignored_0 = (String)AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K2, (Object)"v2");
        });
    }

    @POST
    @Path(value="/publisherEcho")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Publisher<Buffer> publisherEcho(Publisher<Buffer> in) {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        return in.beforeOnComplete(() -> {
            String cfr_ignored_0 = (String)AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K3, (Object)"v3");
        });
    }

    @POST
    @Path(value="/publisherEchoSync")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Publisher<Buffer> publisherEchoSync(Publisher<Buffer> in) {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        in.toCompletionStage().toCompletableFuture().join();
        return Publisher.from((Object)this.ctx.executionContext().bufferAllocator().fromUtf8((CharSequence)"foo")).beforeOnComplete(() -> {
            String cfr_ignored_0 = (String)AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K3, (Object)"v3");
        });
    }

    @GET
    @Path(value="/getCompletionStage")
    @Produces(value={"text/plain"})
    public CompletionStage<String> getCompletionStage() {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        return this.ctx.executionContext().executor().submit(() -> "foo").shareContextOnSubscribe().toCompletionStage().thenApply(str -> {
            AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K2, (Object)"v2");
            return str;
        });
    }

    @GET
    @Path(value="/getCompletionStageCompleteWithStExecutor")
    @Produces(value={"text/plain"})
    public CompletionStage<String> getCompletionStageCompleteWithStExecutor() {
        AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K1, (Object)"v1");
        CompletableFuture future = new CompletableFuture();
        this.ctx.executionContext().executor().schedule(() -> future.complete("foo"), Duration.ofMillis(100L));
        return future.thenApply(str -> {
            AsyncContext.put((ContextMap.Key)AsyncContextHttpFilterVerifier.K2, (Object)"v2");
            return str;
        });
    }
}

