/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.netty.BufferAllocators;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.StreamingHttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Random;

public final class TestUtils {
    private TestUtils() {
    }

    public static CharSequence newLargePayload() {
        int size = 16384;
        StringBuilder sb = new StringBuilder(16384);
        Random rnd = new Random();
        for (int i = 0; i < 16384; ++i) {
            sb.append((char)(65 + rnd.nextInt(26)));
        }
        return sb;
    }

    public static String getContentAsString(StreamingHttpResponse res) {
        return TestUtils.getContentAsString((Publisher<Buffer>)res.payloadBody());
    }

    public static String getContentAsString(Publisher<Buffer> content) {
        try {
            return (String)content.collect(() -> ((BufferAllocator)BufferAllocators.DEFAULT_ALLOCATOR).newBuffer(), Buffer::writeBytes).map(buffer -> buffer.toString(StandardCharsets.UTF_8)).toFuture().get();
        }
        catch (Throwable t) {
            throw new ContentReadException("Failed to extract content from: " + content, t);
        }
    }

    public static final class ContentReadException
    extends RuntimeException {
        private static final long serialVersionUID = -1340168051096097707L;

        public ContentReadException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

