/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.router.jersey.AbstractJerseyStreamingHttpServiceTest;
import io.servicetalk.http.router.jersey.AbstractResourceTest;
import io.servicetalk.http.router.jersey.TestUtils;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Execution(value=ExecutionMode.CONCURRENT)
class SynchronousResourceTest
extends AbstractResourceTest {
    SynchronousResourceTest() {
    }

    @Override
    String resourcePath() {
        return "/sync";
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void uriBuilding(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.get("/uris/relative"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "/async/text");
        this.sendAndAssertResponse(this.get("/uris/absolute"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "http://" + this.host() + "/sync/uris/absolute");
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void queryParameterAreEncoded(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.get("/uris/relative?script=<foo;-/?:@=+$>"), HttpResponseStatus.BAD_REQUEST, HttpHeaderValues.TEXT_PLAIN, "Illegal character in query at index 49: http://" + this.host() + "/sync/uris/relative?script=<foo;-/?:@=+$>");
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void customResponseStatus(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertNoResponse(this.get("/statuses/444"), HttpResponseStatus.of((int)444, (String)"Three fours!"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void pathParams(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.get("/matrix/ps;foo=bar1;foo=bar2/params;mp=bar3;mp=bar4"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: foo=bar1,bar2 & ps & bar3,bar4");
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void bogusChunked(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.get("/bogus-chunked"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "foo");
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void servicetalkRequestContext(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.get("/servicetalk-request"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: /sync/servicetalk-request");
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void http10Support(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.get("/text").version(HttpProtocolVersion.HTTP_1_0), HttpProtocolVersion.HTTP_1_0, HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Object)"GOT: null & null"), (String __) -> 16);
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postTextStrInPubOut(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/text-strin-pubout", "bar2", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Object)"GOT: bar2"), __ -> null);
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postTextPubInStrOut(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/text-pubin-strout", "bar3", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: bar3");
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postTextPubInPubOut(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/text-pubin-pubout", "bar23", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Object)"GOT: bar23"), __ -> null);
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void getTextPubResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.get("/text-pub-response?i=206"), HttpResponseStatus.PARTIAL_CONTENT, HttpHeaderValues.TEXT_PLAIN, "GOT: 206");
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postTextOioStreams(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/text-oio-streams", "bar4", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "GOT: bar4");
        CharSequence payload = TestUtils.newLargePayload();
        this.sendAndAssertResponse(this.post("/text-oio-streams", payload, HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Object)("GOT: " + payload)), __ -> null);
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postJsonOioStreams(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/json-oio-streams", "{\"foo\":123}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"got\":{\"foo\":123}}"), String::length);
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postJsonMapInPubOut(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/json-mapin-pubout", "{\"key\":\"val2\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"key\":\"val2\",\"foo\":\"bar3\"}"), __ -> null);
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postJsonPubInMapOut(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/json-pubin-mapout", "{\"key\":\"val3\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"key\":\"val3\",\"foo\":\"bar4\"}"), this.getJsonResponseContentLengthExtractor());
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postJsonPubInPubOut(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/json-pubin-pubout", "{\"key\":\"val4\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"key\":\"val4\",\"foo\":\"bar5\"}"), __ -> null);
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postJsonBufSingleInSingleOutResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/json-buf-sglin-sglout-response", "{\"key\":\"val6\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.ACCEPTED, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"key\":\"val6\",\"foo\":\"bar6\"}"), __ -> null);
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postJsonBufPubInPubOut(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/json-buf-pubin-pubout", "{\"key\":\"val6\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"KEY\":\"VAL6\"}"), __ -> null);
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postJsonBufPubInPubOutResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/json-buf-pubin-pubout-response", "{\"key\":\"val7\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.ACCEPTED, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"KEY\":\"VAL7\"}"), __ -> null);
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void postJsonPojoInPojoOutResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.post("/json-pojoin-pojoout-response", "{\"aString\":\"val9\",\"anInt\":123}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.ACCEPTED, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"aString\":\"val9x\",\"anInt\":124}"), this.getJsonResponseContentLengthExtractor());
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"io.servicetalk.http.router.jersey.AbstractResourceTest#data"})
    void defaultSecurityContext(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.sendAndAssertResponse(this.get("/security-context"), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"authenticationScheme\":null,\"secure\":false,\"userPrincipal\":null}"), this.getJsonResponseContentLengthExtractor());
    }
}

