/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.router.jersey.AbstractJerseyStreamingHttpServiceTest;
import io.servicetalk.http.router.jersey.resources.SynchronousResources;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Priority;
import javax.management.remote.JMXPrincipal;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class SecurityFilterTest
extends AbstractJerseyStreamingHttpServiceTest {
    SecurityFilterTest() {
    }

    @Override
    protected Application application() {
        return new TestApplication();
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void defaultSecurityContext(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        SecurityFilterTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.get("/sync/security-context"), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"authenticationScheme\":\"bar\",\"secure\":true,\"userPrincipal\":{\"name\":\"foo\"}}"), this.getJsonResponseContentLengthExtractor());
            this.sendAndAssertResponse(this.get("/sync/security-context?none=true"), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"authenticationScheme\":null,\"secure\":false,\"userPrincipal\":null}"), this.getJsonResponseContentLengthExtractor());
        });
    }

    static class TestApplication
    extends Application {
        TestApplication() {
        }

        public Set<Class<?>> getClasses() {
            return new HashSet(Arrays.asList(TestSecurityFilter.class, SynchronousResources.class));
        }
    }

    @Provider
    @Priority(value=1000)
    public static class TestSecurityFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestCtx) {
            if ("true".equals(requestCtx.getUriInfo().getQueryParameters().getFirst((Object)"none"))) {
                return;
            }
            requestCtx.setSecurityContext(new SecurityContext(){

                public Principal getUserPrincipal() {
                    return new JMXPrincipal("foo");
                }

                public boolean isUserInRole(String role) {
                    return false;
                }

                public boolean isSecure() {
                    return true;
                }

                public String getAuthenticationScheme() {
                    return "bar";
                }
            });
        }
    }
}

