/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.http.api.BlockingHttpService;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.HttpService;
import io.servicetalk.http.api.StreamingHttpService;
import io.servicetalk.http.router.jersey.AbstractJerseyStreamingHttpServiceTest;
import io.servicetalk.http.router.jersey.AbstractResourceTest;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import io.servicetalk.http.router.jersey.resources.MixedModeResources;
import io.servicetalk.http.router.predicate.HttpPredicateRouterBuilder;
import io.servicetalk.transport.api.ServerContext;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class MixedModeResourceTest
extends AbstractJerseyStreamingHttpServiceTest {
    MixedModeResourceTest() {
    }

    @Override
    protected void setUp(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        super.setUp(api);
        AbstractResourceTest.assumeSafeToDisableOffloading(true, api);
    }

    @Override
    protected Application application() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(MixedModeResources.class);
            }
        };
    }

    @Override
    void configureBuilders(HttpServerBuilder serverBuilder, HttpJerseyRouterBuilder jerseyRouterBuilder) {
        super.configureBuilders(serverBuilder, jerseyRouterBuilder);
        serverBuilder.executionStrategy(HttpExecutionStrategies.offloadNone());
    }

    @Override
    ServerContext buildRouter(HttpServerBuilder httpServerBuilder, HttpService route) throws Exception {
        StreamingHttpService router = new HttpPredicateRouterBuilder().whenPathEquals("/mixed-mode/cs-string").executionStrategy(HttpExecutionStrategies.defaultStrategy()).thenRouteTo(route).when(__ -> true).executionStrategy(HttpExecutionStrategies.offloadNone()).thenRouteTo(route).buildStreaming();
        return httpServerBuilder.listenStreamingAndAwait(router);
    }

    @Override
    ServerContext buildRouter(HttpServerBuilder httpServerBuilder, StreamingHttpService route) throws Exception {
        StreamingHttpService router = new HttpPredicateRouterBuilder().whenPathEquals("/mixed-mode/cs-string").executionStrategy(HttpExecutionStrategies.defaultStrategy()).thenRouteTo(route).when(__ -> true).executionStrategy(HttpExecutionStrategies.offloadNone()).thenRouteTo(route).buildStreaming();
        return httpServerBuilder.listenStreamingAndAwait(router);
    }

    @Override
    ServerContext buildRouter(HttpServerBuilder httpServerBuilder, BlockingHttpService route) throws Exception {
        StreamingHttpService router = new HttpPredicateRouterBuilder().whenPathEquals("/mixed-mode/cs-string").executionStrategy(HttpExecutionStrategies.defaultStrategy()).thenRouteTo(route).when(__ -> true).executionStrategy(HttpExecutionStrategies.offloadNone()).thenRouteTo(route).buildStreaming();
        return httpServerBuilder.listenStreamingAndAwait(router);
    }

    @Override
    ServerContext buildRouter(HttpServerBuilder httpServerBuilder, BlockingStreamingHttpService route) throws Exception {
        StreamingHttpService router = new HttpPredicateRouterBuilder().whenPathEquals("/mixed-mode/cs-string").executionStrategy(HttpExecutionStrategies.defaultStrategy()).thenRouteTo(route).when(__ -> true).executionStrategy(HttpExecutionStrategies.offloadNone()).thenRouteTo(route).buildStreaming();
        return httpServerBuilder.listenStreamingAndAwait(router);
    }

    @Override
    protected String testUri(String path) {
        return "/mixed-mode" + path;
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void noOffloadsIsSupported(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        MixedModeResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.get("/string"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.stringContainsInOrder(Collections.singleton("stserverio")), String::length);
            this.sendAndAssertResponse(this.get("/single-string"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.stringContainsInOrder(Collections.singleton("stserverio")), String::length);
        });
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void noOffloadsOverrideIsSupported(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        MixedModeResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/cs-string"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.not((Matcher)Matchers.stringContainsInOrder(Collections.singleton("stserverio"))), String::length));
    }
}

