/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.router.jersey.AbstractJerseyStreamingHttpServiceTest;
import io.servicetalk.http.router.jersey.resources.SynchronousResources;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class IllBehavedRequestFilterTest
extends AbstractJerseyStreamingHttpServiceTest {
    IllBehavedRequestFilterTest() {
    }

    @Override
    protected Application application() {
        return new TestApplication();
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void inputStreamConsumingResource(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        this.sendAndAssertResponse(this.post("/sync/json-mapin-pubout", "x{\"key\":\"val2\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"key\":\"val2\",\"foo\":\"bar3\"}"), __ -> null);
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void publisherConsumingResource(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        this.sendAndAssertNoResponse(this.post("/sync/json-pubin-pubout", "x{\"key\":\"val4\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    static class TestApplication
    extends Application {
        TestApplication() {
        }

        public Set<Class<?>> getClasses() {
            return new HashSet(Arrays.asList(IllBehavedRequestFilter.class, SynchronousResources.class));
        }
    }

    @Provider
    @Priority(value=1000)
    public static class IllBehavedRequestFilter
    implements ContainerRequestFilter {
        public void filter(ContainerRequestContext requestCtx) throws IOException {
            int read = requestCtx.getEntityStream().read();
            if (read != 120) {
                requestCtx.abortWith(Response.status((Response.Status)Response.Status.PAYMENT_REQUIRED).build());
            }
        }
    }
}

