/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.ExecutorExtension;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.router.jersey.AbstractJerseyStreamingHttpServiceTest;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import io.servicetalk.http.router.jersey.JerseyRouteExecutionStrategy;
import io.servicetalk.http.router.jersey.resources.ExecutionStrategyResources;
import io.servicetalk.router.api.RouteExecutionStrategyFactory;
import io.servicetalk.router.utils.internal.DefaultRouteExecutionStrategyFactory;
import io.servicetalk.transport.netty.internal.GlobalExecutionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsNot;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

final class ExecutionStrategyTest
extends AbstractJerseyStreamingHttpServiceTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @RegisterExtension
    static final ExecutorExtension<Executor> ROUTER_EXEC = ExecutorExtension.withCachedExecutor((String)"router").setClassLevel(true);
    @RegisterExtension
    static final ExecutorExtension<Executor> ROUTE_EXEC = ExecutorExtension.withCachedExecutor((String)"route").setClassLevel(true);
    private static final Map<String, TestExecutorStrategy> ROOT_PATHS_EXEC_STRATS = new HashMap<String, TestExecutorStrategy>();
    private static final Map<String, TestExecutorStrategy> SUB_PATHS_EXEC_STRATS;
    private static final Map<String, TestMode> SUB_SUB_PATH_TEST_MODES;
    private TestExecutorStrategy routerExecutionStrategy;
    private TestExecutorStrategy classExecutionStrategy;
    private TestExecutorStrategy methodExecutionStrategy;
    private TestMode testMode;
    private String path;

    ExecutionStrategyTest() {
    }

    void setUp(TestExecutorStrategy routerExecutionStrategy, TestExecutorStrategy classExecutionStrategy, TestExecutorStrategy methodExecutionStrategy, TestMode testMode, String path, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.routerExecutionStrategy = routerExecutionStrategy;
        this.classExecutionStrategy = classExecutionStrategy;
        this.methodExecutionStrategy = methodExecutionStrategy;
        this.testMode = testMode;
        this.path = path;
        Assumptions.assumeFalse((routerExecutionStrategy == TestExecutorStrategy.NO_OFFLOADS && api == AbstractJerseyStreamingHttpServiceTest.RouterApi.BLOCKING_STREAMING ? 1 : 0) != 0, (String)"Don't deadlock");
        Assertions.assertDoesNotThrow(() -> super.setUp(api));
    }

    static Collection<Arguments> data() {
        ArrayList<Arguments> parameters = new ArrayList<Arguments>();
        Arrays.stream(AbstractJerseyStreamingHttpServiceTest.RouterApi.values()).forEach(api -> Arrays.stream(TestExecutorStrategy.values()).forEach(routerExecutionStrategy -> ROOT_PATHS_EXEC_STRATS.forEach((rootPath, classExecutionStrategy) -> SUB_PATHS_EXEC_STRATS.forEach((subPath, methodExecutionStrategy) -> SUB_SUB_PATH_TEST_MODES.forEach((subSubPath, testMode) -> {
            String path = rootPath + subPath + subSubPath;
            parameters.add(Arguments.of((Object[])new Object[]{routerExecutionStrategy, classExecutionStrategy, methodExecutionStrategy, testMode, path, api}));
        })))));
        return parameters;
    }

    static RouteExecutionStrategyFactory<HttpExecutionStrategy> asFactory(Map<String, HttpExecutionStrategy> executionStrategies) {
        return id -> {
            HttpExecutionStrategy stored = (HttpExecutionStrategy)executionStrategies.get(id);
            return stored != null ? stored : (HttpExecutionStrategy)DefaultRouteExecutionStrategyFactory.getUsingDefaultStrategyFactory((String)id);
        };
    }

    @Override
    void configureBuilders(HttpServerBuilder serverBuilder, HttpJerseyRouterBuilder jerseyRouterBuilder) {
        this.routerExecutionStrategy.configureRouterBuilder(serverBuilder, ROUTER_EXEC.executor());
        jerseyRouterBuilder.routeExecutionStrategyFactory(ExecutionStrategyTest.asFactory(Collections.singletonMap("test", new JerseyRouteExecutionStrategy(HttpExecutionStrategies.defaultStrategy(), ROUTE_EXEC.executor()))));
    }

    @Override
    protected Application application() {
        return new TestApplication();
    }

    @ParameterizedTest(name="{5} {4} :: r={0}, c={1}, m={2} {3}")
    @MethodSource(value={"data"})
    void testResource(TestExecutorStrategy routerExecutionStrategy, TestExecutorStrategy classExecutionStrategy, TestExecutorStrategy methodExecutionStrategy, TestMode testMode, String path, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(routerExecutionStrategy, classExecutionStrategy, methodExecutionStrategy, testMode, path, api);
        ExecutionStrategyTest.runTwiceToEnsureEndpointCache(this::runTest);
    }

    private void runTest() {
        Map threadingInfo;
        String resBody = this.testMode.sendTestRequest(this.path, this);
        try {
            threadingInfo = (Map)OBJECT_MAPPER.readValue(resBody, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to test: " + this.path, e);
        }
        String context = String.format("path=%s, router=%s, class=%s, method=%s, mode=%s : %s", new Object[]{this.path, this.routerExecutionStrategy, this.classExecutionStrategy, this.methodExecutionStrategy, this.testMode, resBody});
        switch (this.routerExecutionStrategy) {
            case DEFAULT: {
                switch (this.classExecutionStrategy) {
                    case DEFAULT: 
                    case NO_OFFLOADS: {
                        switch (this.methodExecutionStrategy) {
                            case DEFAULT: 
                            case NO_OFFLOADS: {
                                this.assertGlobalExecutor(this.testMode, context, threadingInfo);
                                return;
                            }
                            case EXEC: {
                                this.assertOffloaded(this.testMode, context, threadingInfo);
                                return;
                            }
                        }
                    }
                    case EXEC: {
                        switch (this.methodExecutionStrategy) {
                            case DEFAULT: 
                            case EXEC: {
                                this.assertOffloaded(this.testMode, context, threadingInfo);
                                return;
                            }
                            case NO_OFFLOADS: {
                                this.assertGlobalExecutor(this.testMode, context, threadingInfo);
                                return;
                            }
                        }
                    }
                }
            }
            case EXEC: {
                switch (this.classExecutionStrategy) {
                    case DEFAULT: 
                    case NO_OFFLOADS: {
                        switch (this.methodExecutionStrategy) {
                            case DEFAULT: 
                            case NO_OFFLOADS: {
                                this.assertRouterExecutor(this.testMode, context, threadingInfo);
                                return;
                            }
                            case EXEC: {
                                this.assertOffloaded(this.testMode, context, threadingInfo);
                                return;
                            }
                        }
                    }
                    case EXEC: {
                        switch (this.methodExecutionStrategy) {
                            case DEFAULT: 
                            case EXEC: {
                                this.assertOffloaded(this.testMode, context, threadingInfo);
                                return;
                            }
                            case NO_OFFLOADS: {
                                this.assertRouterExecutor(this.testMode, context, threadingInfo);
                                return;
                            }
                        }
                    }
                }
            }
            case NO_OFFLOADS: {
                switch (this.classExecutionStrategy) {
                    case DEFAULT: {
                        switch (this.methodExecutionStrategy) {
                            case DEFAULT: {
                                this.assertGlobalExecutor(this.testMode, context, threadingInfo);
                                return;
                            }
                            case NO_OFFLOADS: {
                                ExecutionStrategyTest.assertDefaultNoOffloadsExecutor(this.testMode, context, threadingInfo);
                                return;
                            }
                            case EXEC: {
                                ExecutionStrategyTest.assertRouteExecutor(this.testMode, context, threadingInfo);
                                return;
                            }
                        }
                    }
                    case EXEC: {
                        switch (this.methodExecutionStrategy) {
                            case DEFAULT: 
                            case EXEC: {
                                ExecutionStrategyTest.assertRouteExecutor(this.testMode, context, threadingInfo);
                                return;
                            }
                            case NO_OFFLOADS: {
                                ExecutionStrategyTest.assertDefaultNoOffloadsExecutor(this.testMode, context, threadingInfo);
                                return;
                            }
                        }
                    }
                    case NO_OFFLOADS: {
                        switch (this.methodExecutionStrategy) {
                            case DEFAULT: 
                            case NO_OFFLOADS: {
                                ExecutionStrategyTest.assertDefaultNoOffloadsExecutor(this.testMode, context, threadingInfo);
                                return;
                            }
                            case EXEC: {
                                ExecutionStrategyTest.assertRouteExecutor(this.testMode, context, threadingInfo);
                            }
                        }
                    }
                }
            }
        }
    }

    private void assertGlobalExecutor(TestMode testMode, String context, Map<String, String> threadingInfo) {
        MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("thread"), ExecutionStrategyTest.isGlobalExecutorThread());
        MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("exec"), ExecutionStrategyTest.isGlobalExecutor());
        if (testMode.rs) {
            if (testMode == TestMode.POST_RS && this.api == AbstractJerseyStreamingHttpServiceTest.RouterApi.BLOCKING_STREAMING) {
                MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("rs-thread"), ExecutionStrategyTest.isIoExecutorThread());
            } else {
                MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("rs-thread"), ExecutionStrategyTest.isGlobalExecutorThread());
            }
        }
    }

    private void assertOffloaded(TestMode testMode, String context, Map<String, String> threadingInfo) {
        MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("thread"), (Matcher)IsNot.not(ExecutionStrategyTest.isIoExecutorThread()));
        MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("exec"), (Matcher)IsNot.not(ExecutionStrategyTest.isIoExecutor()));
        if (testMode.rs) {
            MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("rs-thread"), (Matcher)IsNot.not(ExecutionStrategyTest.isIoExecutorThread()));
        }
    }

    private static void assertRouteExecutor(TestMode testMode, String context, Map<String, String> threadingInfo) {
        MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("thread"), ExecutionStrategyTest.isRouteExecutorThread());
        MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("exec"), ExecutionStrategyTest.isRouteExecutor());
        if (testMode.rs) {
            MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("rs-thread"), ExecutionStrategyTest.isRouteExecutorThread());
        }
    }

    private void assertRouterExecutor(TestMode testMode, String context, Map<String, String> threadingInfo) {
        MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("thread"), ExecutionStrategyTest.isRouterExecutorThread());
        MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("exec"), ExecutionStrategyTest.isRouterExecutor());
        if (testMode.rs) {
            if (testMode == TestMode.POST_RS && this.api == AbstractJerseyStreamingHttpServiceTest.RouterApi.BLOCKING_STREAMING) {
                MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("rs-thread"), ExecutionStrategyTest.isIoExecutorThread());
            } else {
                MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("rs-thread"), ExecutionStrategyTest.isRouterExecutorThread());
            }
        }
    }

    private static void assertDefaultNoOffloadsExecutor(TestMode testMode, String context, Map<String, String> threadingInfo) {
        MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("thread"), ExecutionStrategyTest.isIoExecutorThread());
        MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("exec"), ExecutionStrategyTest.isGlobalExecutor());
        if (testMode.rs) {
            MatcherAssert.assertThat((String)context, (Object)threadingInfo.get("rs-thread"), ExecutionStrategyTest.isIoExecutorThread());
        }
    }

    private static Matcher<String> isGlobalExecutor() {
        return new ExecutorMatcher(GlobalExecutionContext.globalExecutionContext().executor(), "st-executor");
    }

    private static Matcher<String> isIoExecutor() {
        return new ExecutorMatcher(GlobalExecutionContext.globalExecutionContext().ioExecutor(), "st-stserverio");
    }

    private static Matcher<String> isGlobalExecutorThread() {
        return Matchers.startsWith((String)"servicetalk-global-executor");
    }

    private static Matcher<String> isIoExecutorThread() {
        return Matchers.startsWith((String)"stserverio-");
    }

    private static Matcher<String> isRouteExecutor() {
        return new ExecutorMatcher(ROUTE_EXEC.executor(), "route-executor");
    }

    private static Matcher<String> isRouteExecutorThread() {
        return Matchers.startsWith((String)"route-");
    }

    private static Matcher<String> isRouterExecutor() {
        return new ExecutorMatcher(ROUTER_EXEC.executor(), "router-executor");
    }

    private static Matcher<String> isRouterExecutorThread() {
        return Matchers.startsWith((String)"router-");
    }

    static {
        ROOT_PATHS_EXEC_STRATS.put("/rsc-default", TestExecutorStrategy.DEFAULT);
        ROOT_PATHS_EXEC_STRATS.put("/rsc-rte-exec-id", TestExecutorStrategy.EXEC);
        ROOT_PATHS_EXEC_STRATS.put("/rsc-rte-no-offloads", TestExecutorStrategy.NO_OFFLOADS);
        SUB_PATHS_EXEC_STRATS = new HashMap<String, TestExecutorStrategy>();
        SUB_PATHS_EXEC_STRATS.put("/subrsc-default", TestExecutorStrategy.DEFAULT);
        SUB_PATHS_EXEC_STRATS.put("/subrsc-rte-exec-id", TestExecutorStrategy.EXEC);
        SUB_PATHS_EXEC_STRATS.put("/subrsc-rte-no-offloads", TestExecutorStrategy.NO_OFFLOADS);
        SUB_SUB_PATH_TEST_MODES = new HashMap<String, TestMode>();
        SUB_SUB_PATH_TEST_MODES.put("", TestMode.GET);
        SUB_SUB_PATH_TEST_MODES.put("-single", TestMode.GET_RS);
        SUB_SUB_PATH_TEST_MODES.put("-single-response", TestMode.GET_RS);
        SUB_SUB_PATH_TEST_MODES.put("-single-buffer", TestMode.GET_RS);
        SUB_SUB_PATH_TEST_MODES.put("-single-mapped", TestMode.POST_RS);
        SUB_SUB_PATH_TEST_MODES.put("-publisher-mapped", TestMode.POST_RS);
    }

    private static class ExecutorMatcher
    extends TypeSafeMatcher<String> {
        final String match;
        final String name;

        ExecutorMatcher(Object instance, String name) {
            this.match = instance.toString();
            this.name = name;
        }

        public void describeTo(Description description) {
            description.appendText("a " + this.name + " Executor of ").appendValue((Object)this.match);
        }

        public void describeMismatchSafely(String item, Description mismatchDescription) {
            mismatchDescription.appendText("was ").appendValue((Object)item);
        }

        protected boolean matchesSafely(String item) {
            return item.equals(this.match);
        }
    }

    protected static enum TestMode {
        GET(false){

            @Override
            String sendTestRequest(String path, AbstractJerseyStreamingHttpServiceTest reqHelper) {
                return reqHelper.sendAndAssertStatusOnly(reqHelper.get(path), HttpResponseStatus.OK);
            }
        }
        ,
        GET_RS(true){

            @Override
            String sendTestRequest(String path, AbstractJerseyStreamingHttpServiceTest reqHelper) {
                return GET.sendTestRequest(path, reqHelper);
            }
        }
        ,
        POST_RS(true){

            @Override
            String sendTestRequest(String path, AbstractJerseyStreamingHttpServiceTest reqHelper) {
                return reqHelper.sendAndAssertStatusOnly(reqHelper.post(path, "{\"foo\":\"bar\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK);
            }
        };

        private final boolean rs;

        private TestMode(boolean rs) {
            this.rs = rs;
        }

        abstract String sendTestRequest(String var1, AbstractJerseyStreamingHttpServiceTest var2);
    }

    protected static enum TestExecutorStrategy {
        DEFAULT{

            @Override
            void configureRouterBuilder(HttpServerBuilder builder, Executor __) {
            }
        }
        ,
        EXEC{

            @Override
            void configureRouterBuilder(HttpServerBuilder builder, Executor executor) {
                builder.executor(executor).executionStrategy(HttpExecutionStrategies.defaultStrategy());
            }
        }
        ,
        NO_OFFLOADS{

            @Override
            void configureRouterBuilder(HttpServerBuilder builder, Executor __) {
                builder.executionStrategy(HttpExecutionStrategies.offloadNone());
            }
        };


        abstract void configureRouterBuilder(HttpServerBuilder var1, Executor var2);
    }

    static class TestApplication
    extends Application {
        TestApplication() {
        }

        public Set<Class<?>> getClasses() {
            return new HashSet(Arrays.asList(ExecutionStrategyResources.ResourceDefaultStrategy.class, ExecutionStrategyResources.ResourceRouteExecIdStrategy.class, ExecutionStrategyResources.ResourceRouteNoOffloadsStrategy.class));
        }
    }
}

