/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.ExecutorExtension;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.router.jersey.ExecutionStrategyTest;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import io.servicetalk.http.router.jersey.resources.ExecutionStrategyResources;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class ExecutionStrategyConfigurationFailuresTest {
    @RegisterExtension
    static final ExecutorExtension<Executor> TEST_EXEC = ExecutorExtension.withCachedExecutor((String)"test").setClassLevel(true);

    ExecutionStrategyConfigurationFailuresTest() {
    }

    @Test
    void invalidStrategies() {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new HttpJerseyRouterBuilder().buildStreaming(new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(ExecutionStrategyResources.ResourceInvalidExecStrategy.class);
            }
        }));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.both((Matcher)Matchers.containsString((String)"emptyId()")).and(Matchers.containsString((String)"ResourceInvalidExecStrategy")));
    }

    @Test
    void missingRouteExecId() {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new HttpJerseyRouterBuilder().buildStreaming((Application)new ExecutionStrategyTest.TestApplication()));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.both((Matcher)Matchers.containsString((String)"subResourceDefault()")).and(Matchers.containsString((String)"subResourceRouteExecId()")));
    }

    @Test
    void jaxRsAsync() {
        IllegalArgumentException ex = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> new HttpJerseyRouterBuilder().routeExecutionStrategyFactory(ExecutionStrategyTest.asFactory(Collections.singletonMap("test", HttpExecutionStrategies.defaultStrategy()))).buildStreaming(new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(ExecutionStrategyResources.ResourceUnsupportedAsync.class);
            }
        }));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"suspended("), (Matcher)Matchers.containsString((String)"sse("), (Matcher)Matchers.containsString((String)"managed()"), (Matcher)Matchers.containsString((String)"cf()")));
    }
}

