/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.netty.BufferAllocators;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.DeliberateException;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.router.jersey.AbstractJerseyStreamingHttpServiceTest;
import io.servicetalk.http.router.jersey.resources.AsynchronousResources;
import io.servicetalk.http.router.jersey.resources.SynchronousResources;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class ExceptionMapperTest
extends AbstractJerseyStreamingHttpServiceTest {
    private static final String EXCEPTION_RESPONSE_TYPE_HEADER = "X-EXCEPTION-RESPONSE-TYPE";
    private static final HttpResponseStatus STATUS_555 = HttpResponseStatus.of((int)555, (String)"");

    ExceptionMapperTest() {
    }

    @Override
    protected Application application() {
        return new TestApplication();
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void stringResponse(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        ExceptionMapperTest.runTwiceToEnsureEndpointCache(() -> this.testPlainResponse(ExceptionResponseType.STR));
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void bufferResponse(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        ExceptionMapperTest.runTwiceToEnsureEndpointCache(() -> this.testPlainResponse(ExceptionResponseType.BUF));
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void singleBufferResponse(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        ExceptionMapperTest.runTwiceToEnsureEndpointCache(() -> this.testPlainResponse(ExceptionResponseType.SBUF));
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void mapResponse(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        ExceptionMapperTest.runTwiceToEnsureEndpointCache(() -> this.testJsonResponse(ExceptionResponseType.MAP));
    }

    @ParameterizedTest
    @EnumSource(value=AbstractJerseyStreamingHttpServiceTest.RouterApi.class)
    void singleMapResponse(AbstractJerseyStreamingHttpServiceTest.RouterApi api) throws Exception {
        this.setUp(api);
        ExceptionMapperTest.runTwiceToEnsureEndpointCache(() -> {
            Assumptions.assumeTrue((boolean)this.isStreamingJsonEnabled());
            this.testJsonResponse(ExceptionResponseType.SMAP);
        });
    }

    private void testPlainResponse(ExceptionResponseType ert) {
        this.testAllExceptionTypes(ert, HttpHeaderValues.TEXT_PLAIN);
    }

    private void testJsonResponse(ExceptionResponseType ert) {
        this.testAllExceptionTypes(ert, HttpHeaderValues.APPLICATION_JSON);
    }

    private void testAllExceptionTypes(ExceptionResponseType ert, CharSequence expectedContentType) {
        this.sendAndAssertResponse(this.get("/sync/not_a_resource"), ert, expectedContentType, NotFoundException.class);
        this.sendAndAssertResponse(this.get("/sync/text?qp=throw-not-translated"), ert, expectedContentType, DeliberateException.class);
        this.sendAndAssertResponse(this.get("/sync/text?qp=throw-translated"), ert, expectedContentType, WebApplicationException.class);
        this.sendAndAssertResponse(this.get("/async/text?qp=throw-not-translated"), ert, expectedContentType, DeliberateException.class);
        this.sendAndAssertResponse(this.get("/async/text?qp=throw-translated"), ert, expectedContentType, WebApplicationException.class);
        this.sendAndAssertResponse(this.get("/async/failed-text"), ert, expectedContentType, DeliberateException.class);
        this.sendAndAssertResponse(this.get("/async/completable?fail=true"), ert, expectedContentType, DeliberateException.class);
        this.sendAndAssertResponse(this.get("/async/single-response?fail=true"), ert, expectedContentType, DeliberateException.class);
        this.sendAndAssertResponse(this.get("/async/single-map?fail=true"), ert, expectedContentType, DeliberateException.class);
    }

    private void sendAndAssertResponse(StreamingHttpRequest req, ExceptionResponseType ert, CharSequence expectedContentType, Class<? extends Throwable> expectedExceptionClass) {
        req.headers().set((CharSequence)EXCEPTION_RESPONSE_TYPE_HEADER, (CharSequence)ert.toString());
        if (HttpHeaderValues.APPLICATION_JSON.equals(expectedContentType)) {
            this.sendAndAssertResponse(req, STATUS_555, expectedContentType, (Matcher<String>)Matchers.is((Matcher)JsonMatchers.jsonPartEquals((String)"exceptionClassName", (Object)expectedExceptionClass.getName())), this.getJsonResponseContentLengthExtractor());
        } else {
            this.sendAndAssertResponse(req, STATUS_555, expectedContentType, (Matcher<String>)Matchers.is((Object)expectedExceptionClass.getName()), String::length);
        }
    }

    static class TestApplication
    extends Application {
        TestApplication() {
        }

        public Set<Class<?>> getClasses() {
            return new HashSet(Arrays.asList(TestExceptionMapper.class, SynchronousResources.class, AsynchronousResources.class));
        }
    }

    public static class TestExceptionMapper
    implements ExceptionMapper<Throwable> {
        @Context
        private HttpHeaders headers;

        public Response toResponse(Throwable t) {
            return ExceptionResponseType.valueOf(this.headers.getHeaderString(ExceptionMapperTest.EXCEPTION_RESPONSE_TYPE_HEADER)).toResponse(t);
        }
    }

    static enum ExceptionResponseType {
        STR{

            @Override
            Response toResponse(Throwable exception) {
                return Response.status((int)555).header("Content-Type", (Object)"text/plain").entity((Object)exception.getClass().getName()).build();
            }
        }
        ,
        BUF{

            @Override
            Response toResponse(Throwable exception) {
                Buffer buf = BufferAllocators.DEFAULT_ALLOCATOR.fromAscii((CharSequence)exception.getClass().getName());
                return Response.status((int)555).header("Content-Type", (Object)"text/plain").header("Content-Length", (Object)buf.readableBytes()).entity((Object)buf).build();
            }
        }
        ,
        SBUF{

            @Override
            Response toResponse(Throwable exception) {
                Buffer buf = BufferAllocators.DEFAULT_ALLOCATOR.fromAscii((CharSequence)exception.getClass().getName());
                return Response.status((int)555).header("Content-Type", (Object)"text/plain").header("Content-Length", (Object)buf.readableBytes()).entity((Object)new GenericEntity<Single<Buffer>>(Single.succeeded((Object)buf)){}).build();
            }
        }
        ,
        MAP{

            @Override
            Response toResponse(Throwable exception) {
                return Response.status((int)555).header("Content-Type", (Object)"application/json").entity(Collections.singletonMap("exceptionClassName", exception.getClass().getName())).build();
            }
        }
        ,
        SMAP{

            @Override
            Response toResponse(Throwable exception) {
                Map<String, String> map = Collections.singletonMap("exceptionClassName", exception.getClass().getName());
                return Response.status((int)555).header("Content-Type", (Object)"application/json").entity((Object)new GenericEntity<Single<Map<String, String>>>(Single.succeeded(map)){}).build();
            }
        };


        abstract Response toResponse(Throwable var1);
    }
}

