/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.router.jersey.AbstractJerseyStreamingHttpServiceTest;
import io.servicetalk.http.router.jersey.AbstractResourceTest;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class AsynchronousResourceTest
extends AbstractResourceTest {
    AsynchronousResourceTest() {
    }

    @Override
    String resourcePath() {
        return "/async";
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getCompletable(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            StreamingHttpResponse res = this.sendAndAssertResponse(this.get("/completable"), HttpResponseStatus.NO_CONTENT, null, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), __ -> null);
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)"X-Foo-Prop"), (Matcher)Matchers.is((Object)CharSequences.newAsciiString((CharSequence)"barProp")));
            res = this.sendAndAssertResponse(this.get("/completable?fail=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR, null, "");
            MatcherAssert.assertThat((Object)res.headers().contains((CharSequence)"X-Foo-Prop"), (Matcher)Matchers.is((Object)false));
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getStringSingle(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.get("/single-string"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "DONE");
            this.sendAndAssertNoResponse(this.get("/single-string?fail=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void headStringSingle(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.head("/single-string"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), 4);
            this.sendAndAssertNoResponse(this.head("/single-string?fail=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void headCompletable(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            StreamingHttpResponse res = this.sendAndAssertResponse(this.head("/completable"), HttpResponseStatus.NO_CONTENT, null, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), __ -> null);
            MatcherAssert.assertThat((Object)res.headers().get((CharSequence)"X-Foo-Prop"), (Matcher)Matchers.is((Object)CharSequences.newAsciiString((CharSequence)"barProp")));
            res = this.sendAndAssertResponse(this.head("/completable?fail=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR, null, "");
            MatcherAssert.assertThat((Object)res.headers().contains((CharSequence)"X-Foo-Prop"), (Matcher)Matchers.is((Object)false));
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postJsonBufSingleInSingleOut(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.post("/json-buf-sglin-sglout", "{\"key\":\"val5\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"key\":\"val5\",\"foo\":\"bar6\"}"), String::length);
            this.sendAndAssertResponse(this.post("/json-buf-sglin-sglout?fail=true", "{\"key\":\"val5\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.INTERNAL_SERVER_ERROR, null, "");
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getResponseSingle(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.get("/single-response"), HttpResponseStatus.ACCEPTED, HttpHeaderValues.TEXT_PLAIN, "DONE");
            this.sendAndAssertNoResponse(this.get("/single-response?fail=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void headResponseSingle(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.head("/single-response"), HttpResponseStatus.ACCEPTED, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), 4);
            this.sendAndAssertNoResponse(this.head("/single-response?fail=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getResponseSinglePublisherEntity(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/single-response-pub-entity?i=206"), HttpResponseStatus.PARTIAL_CONTENT, HttpHeaderValues.TEXT_PLAIN, "GOT: 206"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void headResponseSinglePublisherEntity(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.head("/single-response-pub-entity?i=206"), HttpResponseStatus.PARTIAL_CONTENT, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), 8));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getMapSingle(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.get("/single-map"), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"foo\":\"bar4\"}"), this.getJsonResponseContentLengthExtractor());
            this.sendAndAssertNoResponse(this.get("/single-map?fail=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void headMapSingle(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.head("/single-map"), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), this.getJsonResponseContentLengthExtractor().andThen(i -> i != null ? Integer.valueOf(14) : null));
            this.sendAndAssertNoResponse(this.head("/single-map?fail=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getPojoSingle(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.get("/single-pojo"), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"aString\":\"boo\",\"anInt\":456}"), this.getJsonResponseContentLengthExtractor());
            this.sendAndAssertNoResponse(this.get("/single-pojo?fail=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void headPojoSingle(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.head("/single-pojo"), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), this.getJsonResponseContentLengthExtractor().andThen(i -> i != null ? Integer.valueOf(29) : null));
            this.sendAndAssertNoResponse(this.head("/single-pojo?fail=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postJsonPojoInPojoOutSingle(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.post("/json-pojoin-pojoout-single", "{\"aString\":\"val6\",\"anInt\":123}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"aString\":\"val6x\",\"anInt\":124}"), this.getJsonResponseContentLengthExtractor());
            this.sendAndAssertNoResponse(this.post("/json-pojoin-pojoout-single?fail=true", "{\"aString\":\"val8\",\"anInt\":123}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void postJsonPojoInPojoOutResponseSingle(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.post("/json-pojoin-pojoout-response-single", "{\"aString\":\"val7\",\"anInt\":123}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.ACCEPTED, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"aString\":\"val7x\",\"anInt\":124}"), this.getJsonResponseContentLengthExtractor());
            this.sendAndAssertNoResponse(this.post("/json-pojoin-pojoout-response-single?fail=true", "{\"aString\":\"val7\",\"anInt\":123}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @Override
    @Disabled(value="Remove this after https://github.com/eclipse-ee4j/jersey/issues/3672 is solved")
    void getJson(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
    }

    @Override
    @Disabled(value="Remove this after https://github.com/eclipse-ee4j/jersey/issues/3672 is solved")
    void putJsonResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
    }

    @Override
    @Disabled(value="Remove this after https://github.com/eclipse-ee4j/jersey/issues/3672 is solved")
    void postJson(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
    }

    @Override
    @Disabled(value="Remove this after https://github.com/eclipse-ee4j/jersey/issues/3672 is solved")
    void postJsonPojoInPojoOut(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
    }

    @Override
    void explicitHead(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        super.explicitHead(serverNoOffloads, api);
    }

    @Override
    void getTextBuffer(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        super.getTextBuffer(serverNoOffloads, api);
    }

    @Override
    void postJsonBuffer(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        super.postJsonBuffer(serverNoOffloads, api);
    }

    @Override
    void postJsonBytes(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        super.postJsonBytes(serverNoOffloads, api);
    }

    @Override
    void postTextBuffer(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        super.postTextBuffer(serverNoOffloads, api);
    }

    @Override
    void postTextBufferResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        super.postTextBufferResponse(serverNoOffloads, api);
    }

    @Override
    void postTextBytes(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        super.postTextBytes(serverNoOffloads, api);
    }

    @Override
    void postTextResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        super.postTextResponse(serverNoOffloads, api);
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getVoidCompletion(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            this.sendAndAssertResponse(this.get("/void-completion"), HttpResponseStatus.NO_CONTENT, null, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), __ -> null);
            this.sendAndAssertNoResponse(this.get("/void-completion?defer=true"), HttpResponseStatus.OK);
            this.sendAndAssertNoResponse(this.get("/void-completion?fail=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR);
            this.sendAndAssertNoResponse(this.get("/void-completion?fail=true&defer=true"), HttpResponseStatus.INTERNAL_SERVER_ERROR);
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void failedText(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertNoResponse(this.get("/failed-text"), HttpResponseStatus.INTERNAL_SERVER_ERROR));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void cancelledDelayedText(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertNoResponse(this.get("/failed-text?cancel=true"), HttpResponseStatus.SERVICE_UNAVAILABLE));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void getDelayedText(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/delayed-text?delay=10&unit=MILLISECONDS"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "DONE"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void rsCancelDelayedText(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.sendAndAssertResponse(this.get("/delayed-text?delay=1&unit=DAYS"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "DONE", 1, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)ex.getCause(), (Matcher)Matchers.instanceOf(TimeoutException.class));
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void completedStageResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/response-comsta"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "DONE"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void delayedStageResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/delayed-response-comsta?delay=10&unit=MILLISECONDS"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "DONE"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void rsCancelDelayedDelayedStageResponse(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.COMPLETION_STAGE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.sendAndAssertResponse(this.get("/delayed-response-comsta?delay=10&unit=DAYS"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "DONE", 1, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)ex.getCause(), (Matcher)Matchers.instanceOf(TimeoutException.class));
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void resumeSuspended(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.ASYNC_RESPONSE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/suspended/resume"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "DONE"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void cancelSuspended(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.ASYNC_RESPONSE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertNoResponse(this.get("/suspended/cancel"), HttpResponseStatus.SERVICE_UNAVAILABLE));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void setTimeOutResumeSuspended(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.ASYNC_RESPONSE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/suspended/timeout-resume"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "DONE"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void setTimeOutExpire(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.ASYNC_RESPONSE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertNoResponse(this.get("/suspended/timeout-expire"), HttpResponseStatus.SERVICE_UNAVAILABLE));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void setTimeOutExpireHandled(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.ASYNC_RESPONSE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertNoResponse(this.get("/suspended/timeout-expire-handled"), HttpResponseStatus.GATEWAY_TIMEOUT));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void setTimeOutResumed(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.ASYNC_RESPONSE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/suspended/resume-timeout"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "DONE"));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void rsCancelSuspended(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.ASYNC_RESPONSE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> {
            RuntimeException ex = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.sendAndAssertResponse(this.get("/suspended/busy"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, "DONE", 1, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)ex.getCause(), (Matcher)Matchers.instanceOf(TimeoutException.class));
        });
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void resumeSuspendedWithJson(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.ASYNC_RESPONSE);
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/suspended/json"), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"foo\":\"bar3\"}"), this.getJsonResponseContentLengthExtractor()));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void sseStream(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.SSE);
        this.assumeStreaming();
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/sse/stream"), HttpResponseStatus.OK, CharSequences.newAsciiString((CharSequence)"text/event-stream"), (Matcher<String>)Matchers.is((Object)IntStream.range(0, 10).mapToObj(i -> "data: foo" + i + "\n\n").collect(Collectors.joining())), __ -> null));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void sseBroadcast(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.SSE);
        this.assumeStreaming();
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/sse/broadcast"), HttpResponseStatus.OK, CharSequences.newAsciiString((CharSequence)"text/event-stream"), (Matcher<String>)Matchers.is((Object)("data: bar\n\n" + IntStream.range(0, 10).mapToObj(i -> "data: foo" + i + "\n\n").collect(Collectors.joining()))), __ -> null));
    }

    @ParameterizedTest(name="{1} server-no-offloads = {0}")
    @MethodSource(value={"data"})
    void sseUnsupported(boolean serverNoOffloads, AbstractJerseyStreamingHttpServiceTest.RouterApi api) {
        this.setUp(serverNoOffloads, api);
        this.assumeOffloads(AssumeOffloadsReason.SSE);
        this.assumeStreaming();
        AsynchronousResourceTest.runTwiceToEnsureEndpointCache(() -> this.sendAndAssertResponse(this.get("/sse/unsupported"), HttpResponseStatus.OK, CharSequences.newAsciiString((CharSequence)"text/event-stream"), (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), __ -> null));
    }

    private void assumeOffloads(AssumeOffloadsReason reason) {
        Assumptions.assumeFalse((boolean)this.serverNoOffloads(), () -> reason.message + " can't be used with noOffloads");
    }

    private void assumeStreaming() {
        Assumptions.assumeTrue((this.api == AbstractJerseyStreamingHttpServiceTest.RouterApi.ASYNC_STREAMING || this.api == AbstractJerseyStreamingHttpServiceTest.RouterApi.BLOCKING_STREAMING ? 1 : 0) != 0, (String)"not supported for aggregated APIs");
    }

    private static enum AssumeOffloadsReason {
        COMPLETION_STAGE("CompletionStage responses rely on suspended async response which"),
        ASYNC_RESPONSE("Suspended async response"),
        SSE("SSE relies on suspended async response which");

        private final String message;

        private AssumeOffloadsReason(String message) {
            this.message = message;
        }
    }
}

