/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.HttpServerBuilder;
import io.servicetalk.http.api.StreamingHttpServiceFilterFactory;
import io.servicetalk.http.netty.AsyncContextHttpFilterVerifier;
import io.servicetalk.http.router.jersey.AbstractJerseyStreamingHttpServiceTest;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import io.servicetalk.http.router.jersey.resources.AsyncContextResources;
import io.servicetalk.test.resources.TestUtils;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import javax.ws.rs.core.Application;
import net.javacrumbs.jsonunit.JsonMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AsyncContextTest
extends AbstractJerseyStreamingHttpServiceTest {
    private final BlockingQueue<Throwable> errors = new LinkedBlockingDeque<Throwable>();
    private boolean lazyPayload;
    private boolean hasK2;
    private boolean hasK3;

    AsyncContextTest() {
    }

    void setUp(boolean lazyPayload, boolean hasK2, boolean hasK3) {
        this.lazyPayload = lazyPayload;
        this.hasK2 = hasK2;
        this.hasK3 = hasK3;
        Assertions.assertDoesNotThrow(() -> super.setUp(AbstractJerseyStreamingHttpServiceTest.RouterApi.ASYNC_STREAMING));
    }

    @AfterEach
    void assertNoErrors() {
        TestUtils.assertNoAsyncErrors(this.errors);
    }

    @Override
    protected Application application() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(AsyncContextResources.class);
            }
        };
    }

    @Override
    void configureBuilders(HttpServerBuilder serverBuilder, HttpJerseyRouterBuilder jerseyRouterBuilder) {
        super.configureBuilders(serverBuilder, jerseyRouterBuilder);
        serverBuilder.appendServiceFilter((StreamingHttpServiceFilterFactory)new AsyncContextHttpFilterVerifier.AsyncContextAssertionFilter(this.errors, this.lazyPayload, this.hasK2, this.hasK3));
    }

    @Override
    protected String testUri(String path) {
        return "/asyncContext" + path;
    }

    @Test
    void noArgsNoReturn() {
        this.setUp(false, false, false);
        this.sendAndAssertResponse(this.get("/noArgsNoReturn"), HttpResponseStatus.NO_CONTENT, null, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), __ -> null);
    }

    @Test
    void getBuffer() {
        this.setUp(false, false, false);
        this.sendAndAssertResponse(this.get("/getBuffer"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)"foo")), 3);
    }

    @Test
    void postBuffer() {
        this.setUp(false, false, false);
        this.sendAndAssertResponse(this.post("/postBuffer", "foo", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.NO_CONTENT, null, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), __ -> null);
    }

    @Test
    void syncEcho() {
        this.setUp(false, false, false);
        String payload = "foo";
        this.sendAndAssertResponse(this.post("/syncEcho", payload, HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)payload)), payload.length());
    }

    @Test
    void syncEchoResponse() {
        this.setUp(false, false, false);
        String payload = "foo";
        this.sendAndAssertResponse(this.post("/syncEchoResponse", payload, HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)payload)), payload.length());
    }

    @Test
    void postTextOioStreams() {
        this.setUp(true, true, false);
        String payload = "foo";
        this.sendAndAssertResponse(this.post("/postTextOioStreams", payload, HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)payload)), payload.length());
    }

    @Test
    void syncEchoJsonMap() {
        this.setUp(false, false, false);
        this.sendAndAssertResponse(this.post("/syncEchoJsonMap", "{\"key\":\"val1\"}", HttpHeaderValues.APPLICATION_JSON), HttpResponseStatus.OK, HttpHeaderValues.APPLICATION_JSON, (Matcher<String>)JsonMatchers.jsonEquals((Object)"{\"key\":\"val1\",\"foo\":\"bar1\"}"), this.getJsonResponseContentLengthExtractor());
    }

    @Test
    void completable() {
        this.setUp(false, true, false);
        this.sendAndAssertResponse(this.get("/completable"), HttpResponseStatus.NO_CONTENT, null, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), __ -> null);
    }

    @Test
    void getSingleBuffer() {
        this.setUp(false, true, false);
        this.sendAndAssertResponse(this.get("/getSingleBuffer"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)"foo")), 3);
    }

    @Test
    void postSingleBuffer() {
        this.setUp(true, true, false);
        this.sendAndAssertResponse(this.post("/postSingleBuffer", "foo", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.NO_CONTENT, null, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), __ -> null);
    }

    @Test
    void postSingleBufferSync() {
        this.setUp(true, true, false);
        this.sendAndAssertResponse(this.post("/postSingleBufferSync", "foo", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.NO_CONTENT, null, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), __ -> null);
    }

    @Test
    void singleEcho() {
        this.setUp(true, true, false);
        String payload = "foo";
        this.sendAndAssertResponse(this.post("/singleEcho", payload, HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)payload)), payload.length());
    }

    @Test
    void getPublisherBuffer() {
        this.setUp(false, true, true);
        this.sendAndAssertResponse(this.get("/getPublisherBuffer"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)"foo")), __ -> null);
    }

    @Test
    void postPublisherBuffer() {
        this.setUp(true, true, false);
        this.sendAndAssertResponse(this.post("/postPublisherBuffer", "foo", HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.NO_CONTENT, null, (Matcher<String>)Matchers.is((Matcher)Matchers.emptyString()), __ -> null);
    }

    @Test
    void publisherEcho() {
        this.setUp(true, false, true);
        String payload = "foo";
        this.sendAndAssertResponse(this.post("/publisherEcho", payload, HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)payload)), __ -> null);
    }

    @Test
    void publisherEchoSync() {
        this.setUp(true, false, true);
        String payload = "foo";
        this.sendAndAssertResponse(this.post("/publisherEchoSync", payload, HttpHeaderValues.TEXT_PLAIN), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)payload)), __ -> null);
    }

    @Test
    void getCompletionStage() {
        this.setUp(false, true, false);
        this.sendAndAssertResponse(this.get("/getCompletionStage"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)"foo")), 3);
    }

    @Test
    void getCompletionStageCompleteWithStExecutor() {
        this.setUp(false, true, false);
        this.sendAndAssertResponse(this.get("/getCompletionStageCompleteWithStExecutor"), HttpResponseStatus.OK, HttpHeaderValues.TEXT_PLAIN, (Matcher<String>)Matchers.is((Matcher)Matchers.equalTo((Object)"foo")), 3);
    }
}

